/*
 * Decompiled with CFR 0.152.
 */
package net.corda.crypto.impl.serialization;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.crypto.cipher.suite.KeyEncodingService;
import net.corda.serialization.BaseDirectSerializer;
import net.corda.serialization.InternalCustomSerializer;
import net.corda.serialization.InternalDirectSerializer;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lnet/corda/crypto/impl/serialization/PublicKeySerializer;", "Lnet/corda/serialization/BaseDirectSerializer;", "Ljava/security/PublicKey;", "keyEncodingService", "Lnet/corda/crypto/cipher/suite/KeyEncodingService;", "(Lnet/corda/crypto/cipher/suite/KeyEncodingService;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "withInheritance", "", "getWithInheritance", "()Z", "readObject", "reader", "Lnet/corda/serialization/InternalDirectSerializer$ReadObject;", "writeObject", "", "obj", "writer", "Lnet/corda/serialization/InternalDirectSerializer$WriteObject;", "crypto-serialization-impl"})
@Component(service={InternalCustomSerializer.class})
public final class PublicKeySerializer
extends BaseDirectSerializer<PublicKey> {
    @NotNull
    private final KeyEncodingService keyEncodingService;

    @Activate
    public PublicKeySerializer(@Reference(service=KeyEncodingService.class) @NotNull KeyEncodingService keyEncodingService) {
        Intrinsics.checkNotNullParameter((Object)keyEncodingService, (String)"keyEncodingService");
        this.keyEncodingService = keyEncodingService;
    }

    @NotNull
    public Class<PublicKey> getType() {
        return PublicKey.class;
    }

    public boolean getWithInheritance() {
        return true;
    }

    protected void writeObject(@NotNull PublicKey obj, @NotNull InternalDirectSerializer.WriteObject writer) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.putAsBytes(this.keyEncodingService.encodeAsByteArray(obj));
    }

    @NotNull
    protected PublicKey readObject(@NotNull InternalDirectSerializer.ReadObject reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return this.keyEncodingService.decodePublicKey(reader.getAsBytes());
    }
}

