/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.logging.errorReporting;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.common.logging.errorReporting.ErrorCode;
import net.corda.common.logging.errorReporting.ErrorContextProvider;
import net.corda.common.logging.errorReporting.ErrorReporter;
import net.corda.common.logging.errorReporting.ErrorReportingUtilsKt;
import net.corda.common.logging.errorReporting.ErrorResource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u00032\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/corda/common/logging/errorReporting/ErrorReporterImpl;", "Lnet/corda/common/logging/errorReporting/ErrorReporter;", "resourceLocation", "", "locale", "Ljava/util/Locale;", "errorContextProvider", "Lnet/corda/common/logging/errorReporting/ErrorContextProvider;", "(Ljava/lang/String;Ljava/util/Locale;Lnet/corda/common/logging/errorReporting/ErrorContextProvider;)V", "fetchAndFormat", "resource", "property", "params", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getErrorInfo", "error", "Lnet/corda/common/logging/errorReporting/ErrorCode;", "report", "", "logger", "Lorg/slf4j/Logger;", "common-logging"})
@SourceDebugExtension(value={"SMAP\nErrorReporterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorReporterImpl.kt\nnet/corda/common/logging/errorReporting/ErrorReporterImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,41:1\n37#2,2:42\n*S KotlinDebug\n*F\n+ 1 ErrorReporterImpl.kt\nnet/corda/common/logging/errorReporting/ErrorReporterImpl\n*L\n34#1:42,2\n*E\n"})
public final class ErrorReporterImpl
implements ErrorReporter {
    @NotNull
    private final String resourceLocation;
    @NotNull
    private final Locale locale;
    @NotNull
    private final ErrorContextProvider errorContextProvider;

    public ErrorReporterImpl(@NotNull String resourceLocation, @NotNull Locale locale, @NotNull ErrorContextProvider errorContextProvider) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)errorContextProvider, (String)"errorContextProvider");
        this.resourceLocation = resourceLocation;
        this.locale = locale;
        this.errorContextProvider = errorContextProvider;
    }

    private final String fetchAndFormat(String resource, String property, Object[] params) {
        ResourceBundle bundle = ResourceBundle.getBundle(resource, this.locale);
        String template = bundle.getString(property);
        MessageFormat formatter = new MessageFormat(template, this.locale);
        String string = formatter.format(params);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String getErrorInfo(ErrorCode<?> error) {
        String resource = this.resourceLocation + "/ErrorInfo";
        Object[] objectArray = new String[]{ErrorReportingUtilsKt.formatCode(error)};
        String codeMessage = this.fetchAndFormat(resource, "errorCodeMessage", objectArray);
        Object[] objectArray2 = new String[]{this.errorContextProvider.getURL(this.locale)};
        String urlMessage = this.fetchAndFormat(resource, "errorCodeUrl", objectArray2);
        return "[" + codeMessage + " " + urlMessage + "]";
    }

    @Override
    public void report(@NotNull ErrorCode<?> error, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ErrorResource errorResource = ErrorResource.Companion.fromErrorCode(error, this.resourceLocation, this.locale);
        Collection $this$toTypedArray$iv = error.getParameters();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String message = errorResource.getErrorMessage(thisCollection$iv.toArray(new Object[0])) + " " + this.getErrorInfo(error);
        if (error instanceof Exception) {
            logger.error(message, (Throwable)((Object)error));
        } else {
            logger.error(message);
        }
    }
}

