package net.contextfw.web.application;

import net.contextfw.web.application.internal.WebResponder;
import net.contextfw.web.application.internal.component.ComponentBuilderImpl;
import net.contextfw.web.application.internal.servlet.CSSServlet;
import net.contextfw.web.application.internal.servlet.ScriptServlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;

/**
 * Cleans cached resources 
 *
 * <p>
 *  This class can be used to clean cached resources if needed. This is useful if 
 *  part of the resources have been externalized somewhere else than classpath.
 * </p>
 */
@Singleton
public class ResourceCleaner {
    
    @Inject
    private WebResponder webResponder;
    
    @Inject
    private CSSServlet cssServlet;
    
    @Inject
    private ScriptServlet scriptServlet;
    
    @Inject
    private ComponentBuilderImpl builder;
    
    /**
     * Cleans resources
     */
    public void clean() {
        webResponder.clean();
        cssServlet.clean();
        scriptServlet.clean();
        builder.clean();
    }
}
