package net.consentmanager.cm_sdk_android_v3

import android.app.Activity
import android.app.Dialog
import androidx.annotation.Keep

@Keep
interface DialogFactory {
    fun createDialog(activity: Activity): Dialog
}

@Keep
class DefaultDialogFactory : DialogFactory {
    override fun createDialog(activity: Activity): Dialog {
        return Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen)
    }
}
