/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.trie;

import com.google.common.base.Preconditions;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.MutableBytes;

public final class CompactEncoding {
    public static final byte LEAF_TERMINATOR = 16;

    private CompactEncoding() {
    }

    public static Bytes bytesToPath(Bytes bytes) {
        MutableBytes path2 = MutableBytes.create((int)(bytes.size() * 2 + 1));
        int j = 0;
        int i = 0;
        while (i < bytes.size()) {
            byte b = bytes.get(i);
            path2.set(j, (byte)(b >>> 4 & 0xF));
            path2.set(j + 1, (byte)(b & 0xF));
            ++i;
            j += 2;
        }
        path2.set(j, (byte)16);
        return path2;
    }

    public static Bytes encode(Bytes path2) {
        byte low;
        byte high;
        boolean isLeaf;
        int size = path2.size();
        boolean bl = isLeaf = size > 0 && path2.get(size - 1) == 16;
        if (isLeaf) {
            --size;
        }
        MutableBytes encoded2 = MutableBytes.create((int)((size + 2) / 2));
        int i = 0;
        int j = 0;
        if (size % 2 == 1) {
            high = (byte)(isLeaf ? 3 : 1);
            if (((low = path2.get(i++)) & 0xF0) != 0) {
                throw new IllegalArgumentException("Invalid path: contains elements larger than a nibble");
            }
            encoded2.set(j++, (byte)(high << 4 | low));
        } else {
            high = (byte)(isLeaf ? 2 : 0);
            encoded2.set(j++, (byte)(high << 4));
        }
        while (i < size) {
            high = path2.get(i++);
            low = path2.get(i++);
            if ((high & 0xF0) != 0 || (low & 0xF0) != 0) {
                throw new IllegalArgumentException("Invalid path: contains elements larger than a nibble");
            }
            encoded2.set(j++, (byte)(high << 4 | low));
        }
        return encoded2;
    }

    public static Bytes decode(Bytes encoded2) {
        MutableBytes path2;
        int size = encoded2.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        byte magic = encoded2.get(0);
        Preconditions.checkArgument(((magic & 0xC0) == 0 ? 1 : 0) != 0, (Object)"Invalid compact encoding");
        boolean isLeaf = (magic & 0x20) != 0;
        int pathLength = (size - 1) * 2 + (isLeaf ? 1 : 0);
        int i = 0;
        if ((magic & 0x10) != 0) {
            path2 = MutableBytes.create((int)(pathLength + 1));
            path2.set(i++, (byte)(magic & 0xF));
        } else {
            path2 = MutableBytes.create((int)pathLength);
        }
        for (int j = 1; j < size; ++j) {
            byte b = encoded2.get(j);
            path2.set(i++, (byte)(b >>> 4 & 0xF));
            path2.set(i++, (byte)(b & 0xF));
        }
        if (isLeaf) {
            path2.set(i, (byte)16);
        }
        return path2;
    }
}

