/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.consensys.cava.config.Configuration;
import net.consensys.cava.config.ConfigurationError;
import net.consensys.cava.config.DocumentPosition;
import net.consensys.cava.config.InvalidConfigurationPropertyTypeException;
import net.consensys.cava.config.NoConfigurationPropertyException;
import net.consensys.cava.config.Schema;
import net.consensys.cava.config.TomlSerializer;
import net.consensys.cava.toml.Toml;
import net.consensys.cava.toml.TomlArray;
import net.consensys.cava.toml.TomlInvalidTypeException;
import net.consensys.cava.toml.TomlParseResult;
import net.consensys.cava.toml.TomlPosition;
import net.consensys.cava.toml.TomlTable;

final class TomlBackedConfiguration
implements Configuration {
    private final TomlTable toml;
    private final Schema schema;
    private final List<ConfigurationError> errors;

    TomlBackedConfiguration(TomlParseResult toml, @Nullable Schema schema) {
        ArrayList<ConfigurationError> errors = new ArrayList<ConfigurationError>();
        toml.errors().forEach(err -> errors.add(new ConfigurationError(this.documentPosition(err.position()), err.getMessage(), (Throwable)err)));
        if (schema != null) {
            schema.validate(new TomlBackedConfiguration(toml, null)).forEach(errors::add);
        } else {
            schema = Schema.EMPTY;
        }
        this.toml = toml;
        this.schema = schema;
        this.errors = errors;
    }

    @Override
    public List<ConfigurationError> errors() {
        return this.errors;
    }

    @Override
    public void toToml(Appendable appendable) throws IOException {
        new TomlSerializer(this, this.schema).writeTo(appendable);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.toml.dottedKeySet());
        keys.addAll(this.schema.defaultsKeySet());
        return keys;
    }

    @Override
    public boolean contains(String key) {
        return this.toml.contains(key) || this.schema.hasDefault(key);
    }

    @Override
    @Nullable
    public Object get(String key) {
        Object obj = this.toml.get(key);
        if (obj != null) {
            if (obj instanceof TomlArray) {
                return TomlBackedConfiguration.deepToList((TomlArray)obj);
            }
            if (obj instanceof TomlTable) {
                return TomlBackedConfiguration.deepToMap((TomlTable)obj);
            }
            return obj;
        }
        return this.schema.getDefault(key);
    }

    @Override
    @Nullable
    public DocumentPosition inputPositionOf(String key) {
        TomlPosition position = this.toml.inputPositionOf(key);
        if (position == null) {
            return null;
        }
        return this.documentPosition(position);
    }

    private DocumentPosition inputPositionOf(List<String> keyPath) {
        TomlPosition position = this.toml.inputPositionOf(keyPath);
        if (position == null) {
            return null;
        }
        return this.documentPosition(position);
    }

    @Override
    public String getString(String key) {
        return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getString(arg_0), this.schema::getDefaultString);
    }

    @Override
    public int getInteger(String key) {
        return this.getValue(key, keyPath -> {
            Long longValue = this.toml.getLong(keyPath);
            if (longValue != null && longValue > Integer.MAX_VALUE) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "Value of property '" + Toml.joinKeyPath((List)keyPath) + "' is too large for an integer");
            }
            return longValue != null ? Integer.valueOf(longValue.intValue()) : null;
        }, this.schema::getDefaultInteger);
    }

    @Override
    public long getLong(String key) {
        return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getLong(arg_0), this.schema::getDefaultLong);
    }

    @Override
    public double getDouble(String key) {
        return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getDouble(arg_0), this.schema::getDefaultDouble);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getBoolean(arg_0), this.schema::getDefaultBoolean);
    }

    @Override
    public Map<String, Object> getMap(String key) {
        return this.getValue(key, keyPath -> {
            TomlTable table = this.toml.getTable(keyPath);
            if (table == null) {
                return null;
            }
            return TomlBackedConfiguration.deepToMap(table);
        }, this.schema::getDefaultMap);
    }

    @Override
    public List<Object> getList(String key) {
        return this.getValue(key, keyPath -> {
            TomlArray array = this.toml.getArray(keyPath);
            if (array == null) {
                return null;
            }
            return TomlBackedConfiguration.deepToList(array);
        }, this.schema::getDefaultList);
    }

    @Override
    public List<String> getListOfString(String key) {
        return this.getList(key, "strings", TomlArray::containsStrings, this.schema::getDefaultListOfString);
    }

    @Override
    public List<Integer> getListOfInteger(String key) {
        return this.getValue(key, keyPath -> {
            TomlArray array = this.toml.getArray(keyPath);
            if (array == null) {
                return null;
            }
            if (!array.containsLongs()) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "List property '" + Toml.joinKeyPath((List)keyPath) + "' does not contain integers");
            }
            List longList = array.toList();
            return IntStream.range(0, longList.size()).mapToObj(i -> {
                Long value = (Long)longList.get(i);
                if (value > Integer.MAX_VALUE) {
                    throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "Value of property '" + Toml.joinKeyPath((List)keyPath) + "', index " + i + ", is too large for an integer");
                }
                return value.intValue();
            }).collect(Collectors.toList());
        }, this.schema::getDefaultListOfInteger);
    }

    @Override
    public List<Long> getListOfLong(String key) {
        return this.getList(key, "longs", TomlArray::containsLongs, this.schema::getDefaultListOfLong);
    }

    @Override
    public List<Double> getListOfDouble(String key) {
        return this.getList(key, "doubles", TomlArray::containsDoubles, this.schema::getDefaultListOfDouble);
    }

    @Override
    public List<Boolean> getListOfBoolean(String key) {
        return this.getList(key, "booleans", TomlArray::containsBooleans, this.schema::getDefaultListOfBoolean);
    }

    @Override
    public List<Map<String, Object>> getListOfMap(String key) {
        return this.getValue(key, keyPath -> {
            TomlArray array = this.toml.getArray(keyPath);
            if (array == null) {
                return null;
            }
            if (!array.containsTables()) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "List property '" + Toml.joinKeyPath((List)keyPath) + "' does not contain maps");
            }
            List<Object> typedList = TomlBackedConfiguration.deepToList(array);
            return typedList;
        }, this.schema::getDefaultListOfMap);
    }

    private DocumentPosition documentPosition(TomlPosition position) {
        return DocumentPosition.positionAt(position.line(), position.column());
    }

    private <T> T getValue(String key, Function<List<String>, T> tomlGet, Function<String, T> defaultGet) {
        T value;
        List keyPath = Toml.parseDottedKey((String)key);
        try {
            value = tomlGet.apply(keyPath);
        }
        catch (TomlInvalidTypeException e) {
            throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf(keyPath), e.getMessage(), e);
        }
        if (value != null) {
            return value;
        }
        String canonicalKey = Toml.joinKeyPath((List)keyPath);
        value = defaultGet.apply(canonicalKey);
        if (value != null) {
            return value;
        }
        throw new NoConfigurationPropertyException("No value for property '" + canonicalKey + "'");
    }

    private <T> List<T> getList(String key, String typeName, Predicate<TomlArray> tomlCheck, Function<String, List<T>> defaultGet) {
        return this.getValue(key, keyPath -> {
            TomlArray array = this.toml.getArray(keyPath);
            if (array == null) {
                return null;
            }
            if (!tomlCheck.test(array)) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "List property '" + Toml.joinKeyPath((List)keyPath) + "' does not contain " + typeName);
            }
            List typedList = array.toList();
            return typedList;
        }, defaultGet);
    }

    private static List<Object> deepToList(TomlArray array) {
        return array.toList().stream().map(o -> {
            if (o instanceof TomlArray) {
                return TomlBackedConfiguration.deepToList((TomlArray)o);
            }
            if (o instanceof TomlTable) {
                return TomlBackedConfiguration.deepToMap((TomlTable)o);
            }
            return o;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> deepToMap(TomlTable table) {
        return table.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Object o = e.getValue();
            if (o instanceof TomlArray) {
                return TomlBackedConfiguration.deepToList((TomlArray)o);
            }
            if (o instanceof TomlTable) {
                return TomlBackedConfiguration.deepToMap((TomlTable)o);
            }
            return o;
        }));
    }
}

