/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.consensys.cava.config.Configuration;
import net.consensys.cava.config.ConfigurationError;
import net.consensys.cava.config.ConfigurationValidator;
import net.consensys.cava.config.DocumentPosition;
import net.consensys.cava.config.InvalidConfigurationPropertyTypeException;
import net.consensys.cava.config.PropertyValidator;

public final class Schema {
    static final Schema EMPTY = new Schema(Collections.emptyMap(), Collections.emptyMap(), (ListMultimap<String, PropertyValidator<Object>>)ArrayListMultimap.create(), Collections.emptyList());
    private final Map<String, String> propertyDescriptions;
    private final Map<String, Object> propertyDefaults;
    private final ListMultimap<String, PropertyValidator<Object>> propertyValidators;
    private final List<ConfigurationValidator> configurationValidators;

    Schema(Map<String, String> propertyDescriptions, Map<String, Object> propertyDefaults, ListMultimap<String, PropertyValidator<Object>> propertyValidators, List<ConfigurationValidator> configurationValidators) {
        this.propertyDescriptions = propertyDescriptions;
        this.propertyDefaults = propertyDefaults;
        this.propertyValidators = propertyValidators;
        this.configurationValidators = configurationValidators;
    }

    public Set<String> defaultsKeySet() {
        return this.propertyDefaults.keySet();
    }

    @Nullable
    public String description(String key) {
        Objects.requireNonNull(key);
        return this.propertyDescriptions.get(key);
    }

    public boolean hasDefault(String key) {
        Objects.requireNonNull(key);
        return this.propertyDefaults.containsKey(key);
    }

    public Object getDefault(String key) {
        Objects.requireNonNull(key);
        return this.propertyDefaults.get(key);
    }

    @Nullable
    public String getDefaultString(String key) {
        Objects.requireNonNull(key);
        return this.getTypedDefault(key, String.class, "string");
    }

    @Nullable
    public Integer getDefaultInteger(String key) {
        Objects.requireNonNull(key);
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            Long longValue = (Long)obj;
            if (longValue > Integer.MAX_VALUE) {
                throw new InvalidConfigurationPropertyTypeException(null, "Value of property '" + key + "' is too large for an integer");
            }
            return longValue.intValue();
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' was not an integer");
    }

    @Nullable
    public Long getDefaultLong(String key) {
        Objects.requireNonNull(key);
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' was not a long");
    }

    @Nullable
    public Double getDefaultDouble(String key) {
        Objects.requireNonNull(key);
        return this.getTypedDefault(key, Double.class, "double");
    }

    @Nullable
    public Boolean getDefaultBoolean(String key) {
        Objects.requireNonNull(key);
        return this.getTypedDefault(key, Boolean.class, "boolean");
    }

    @Nullable
    public Map<String, Object> getDefaultMap(String key) {
        Objects.requireNonNull(key);
        return this.getTypedDefault(key, Map.class, "map");
    }

    @Nullable
    public List<Object> getDefaultList(String key) {
        Objects.requireNonNull(key);
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' is not a list");
    }

    @Nullable
    public List<String> getDefaultListOfString(String key) {
        Objects.requireNonNull(key);
        return this.getListDefault(key, String.class, "strings");
    }

    @Nullable
    public List<Integer> getDefaultListOfInteger(String key) {
        Objects.requireNonNull(key);
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.isEmpty() || list.get(0) instanceof Integer) {
                return list;
            }
            if (list.get(0) instanceof Long) {
                return IntStream.range(0, list.size()).mapToObj(i -> {
                    Long longValue = (Long)list.get(i);
                    if (longValue == null) {
                        return null;
                    }
                    if (longValue > Integer.MAX_VALUE) {
                        throw new InvalidConfigurationPropertyTypeException(null, "Value of property '" + key + "', index " + i + ", is too large for an integer");
                    }
                    return longValue.intValue();
                }).collect(Collectors.toList());
            }
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' was not a list of integers");
    }

    @Nullable
    public List<Long> getDefaultListOfLong(String key) {
        Objects.requireNonNull(key);
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.isEmpty() || list.get(0) instanceof Long) {
                return list;
            }
            if (list.get(0) instanceof Integer) {
                return list.stream().map(i -> {
                    if (i == null) {
                        return null;
                    }
                    return i.longValue();
                }).collect(Collectors.toList());
            }
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' was not a list of longs");
    }

    @Nullable
    public List<Double> getDefaultListOfDouble(String key) {
        Objects.requireNonNull(key);
        return this.getListDefault(key, Double.class, "doubles");
    }

    @Nullable
    public List<Boolean> getDefaultListOfBoolean(String key) {
        Objects.requireNonNull(key);
        return this.getListDefault(key, Boolean.class, "booleans");
    }

    @Nullable
    public List<Map<String, Object>> getDefaultListOfMap(String key) {
        Objects.requireNonNull(key);
        return this.getListDefault(key, Map.class, "maps");
    }

    @Nullable
    private <T> T getTypedDefault(String key, Class<T> clazz, String typeName) {
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' was not a " + typeName);
    }

    @Nullable
    private <T> List<T> getListDefault(String key, Class<?> listType, String typeName) {
        List list;
        Object obj = this.propertyDefaults.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List && ((list = (List)obj).isEmpty() || listType.isInstance(list.get(0)))) {
            return list;
        }
        throw new InvalidConfigurationPropertyTypeException(null, "Property at '" + key + "' was not a list of " + typeName);
    }

    public Stream<ConfigurationError> validate(Configuration configuration) {
        Objects.requireNonNull(configuration);
        Stream propertyErrors = this.propertyValidators.entries().stream().flatMap(e -> {
            String key = (String)e.getKey();
            PropertyValidator validator = (PropertyValidator)e.getValue();
            Object value = configuration.get(key);
            DocumentPosition position = configuration.inputPositionOf(key);
            List<ConfigurationError> errors = validator.validate(key, position, value);
            if (errors == null) {
                return Stream.empty();
            }
            return errors.stream();
        });
        Stream configErrors = this.configurationValidators.stream().flatMap(v -> {
            List<ConfigurationError> errors = v.validate(configuration);
            if (errors == null) {
                return Stream.empty();
            }
            return errors.stream();
        });
        return Stream.concat(propertyErrors, configErrors);
    }
}

