/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.config;

public final class DocumentPosition {
    private final int line;
    private final int column;

    public static DocumentPosition positionAt(int line, int column) {
        if (line < 1) {
            throw new IllegalArgumentException("line must be >= 1");
        }
        if (column < 1) {
            throw new IllegalArgumentException("column must be >= 1");
        }
        return new DocumentPosition(line, column);
    }

    private DocumentPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DocumentPosition)) {
            return false;
        }
        DocumentPosition other = (DocumentPosition)obj;
        return this.line == other.line && this.column == other.column;
    }

    public int hashCode() {
        return 31 * this.line + this.column;
    }

    public String toString() {
        return "line " + this.line + ", column " + this.column;
    }
}

