/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.consensys.cava.config.ConfigurationError;
import net.consensys.cava.config.DocumentPosition;
import net.consensys.cava.config.EmptyConfiguration;
import net.consensys.cava.config.Schema;
import net.consensys.cava.config.TomlBackedConfiguration;
import net.consensys.cava.toml.Toml;

public interface Configuration {
    public static Configuration fromToml(String toml) {
        return Configuration.fromToml(toml, null);
    }

    public static Configuration fromToml(String toml, @Nullable Schema schema) {
        Objects.requireNonNull(toml);
        return new TomlBackedConfiguration(Toml.parse((String)toml), schema);
    }

    public static Configuration fromToml(Path file) throws IOException {
        return Configuration.fromToml(file, null);
    }

    public static Configuration fromToml(Path file, @Nullable Schema schema) throws IOException {
        Objects.requireNonNull(file);
        return new TomlBackedConfiguration(Toml.parse((Path)file), schema);
    }

    public static Configuration fromToml(InputStream is) throws IOException {
        return Configuration.fromToml(is, null);
    }

    public static Configuration fromToml(InputStream is, @Nullable Schema schema) throws IOException {
        Objects.requireNonNull(is);
        return new TomlBackedConfiguration(Toml.parse((InputStream)is), schema);
    }

    public static Configuration empty() {
        return EmptyConfiguration.EMPTY;
    }

    public static Configuration empty(@Nullable Schema schema) {
        return new EmptyConfiguration(schema);
    }

    default public boolean hasErrors() {
        return !this.errors().isEmpty();
    }

    public List<ConfigurationError> errors();

    default public String toToml() {
        StringBuilder builder = new StringBuilder();
        try {
            this.toToml(builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toToml(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.toToml(writer);
        }
    }

    public void toToml(Appendable var1) throws IOException;

    public Set<String> keySet();

    public boolean contains(String var1);

    @Nullable
    public Object get(String var1);

    @Nullable
    public DocumentPosition inputPositionOf(String var1);

    public String getString(String var1);

    public int getInteger(String var1);

    public long getLong(String var1);

    public double getDouble(String var1);

    public boolean getBoolean(String var1);

    public Map<String, Object> getMap(String var1);

    public List<Object> getList(String var1);

    public List<String> getListOfString(String var1);

    public List<Integer> getListOfInteger(String var1);

    public List<Long> getListOfLong(String var1);

    public List<Double> getListOfDouble(String var1);

    public List<Boolean> getListOfBoolean(String var1);

    public List<Map<String, Object>> getListOfMap(String var1);

    public static String canonicalKey(String key) {
        return Toml.canonicalDottedKey((String)key);
    }
}

