/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.bytes;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.consensys.cava.bytes.ArrayWrappingBytes;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.MutableArrayWrappingBytes32;
import net.consensys.cava.bytes.MutableBytes;

class MutableArrayWrappingBytes
extends ArrayWrappingBytes
implements MutableBytes {
    MutableArrayWrappingBytes(byte[] bytes) {
        super(bytes);
    }

    MutableArrayWrappingBytes(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public void set(int i, byte b) {
        Preconditions.checkElementIndex((int)i, (int)this.size());
        this.bytes[this.offset + i] = b;
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)this.length);
        Preconditions.checkArgument((i + length <= this.length ? 1 : 0) != 0, (String)"Specified length %s is too large: the value has size %s and has only %s bytes from %s", (Object)length, (Object)this.length, (Object)(this.length - i), (Object)i);
        return length == 32 ? new MutableArrayWrappingBytes32(this.bytes, this.offset + i) : new MutableArrayWrappingBytes(this.bytes, this.offset + i, length);
    }

    @Override
    public void fill(byte b) {
        Arrays.fill(this.bytes, this.offset, this.offset + this.length, b);
    }

    @Override
    public Bytes copy() {
        return new ArrayWrappingBytes(this.toArray());
    }
}

