/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.bytes;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.consensys.cava.bytes.AbstractBytes;
import net.consensys.cava.bytes.ArrayWrappingBytes;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.MutableArrayWrappingBytes;
import net.consensys.cava.bytes.MutableBytes;

class ByteBufferWrappingBytes
extends AbstractBytes {
    protected final ByteBuffer byteBuffer;
    protected final int offset;
    protected final int length;

    ByteBufferWrappingBytes(ByteBuffer byteBuffer) {
        this(byteBuffer, 0, byteBuffer.limit());
    }

    ByteBufferWrappingBytes(ByteBuffer byteBuffer, int offset, int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Invalid negative length");
        int bufferLength = byteBuffer.capacity();
        if (bufferLength > 0) {
            Preconditions.checkElementIndex((int)offset, (int)bufferLength);
        }
        Preconditions.checkArgument((offset + length <= bufferLength ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has only %s bytes from offset %s", (Object)length, (Object)(bufferLength - offset), (Object)offset);
        this.byteBuffer = byteBuffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public int getInt(int i) {
        return this.byteBuffer.getInt(this.offset + i);
    }

    @Override
    public long getLong(int i) {
        return this.byteBuffer.getLong(this.offset + i);
    }

    @Override
    public byte get(int i) {
        return this.byteBuffer.get(this.offset + i);
    }

    @Override
    public Bytes slice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)this.length);
        Preconditions.checkArgument((i + length <= this.length ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)this.length, (Object)(this.length - i), (Object)i);
        return new ByteBufferWrappingBytes(this.byteBuffer, this.offset + i, length);
    }

    @Override
    public Bytes copy() {
        if (this.offset == 0 && this.length == this.byteBuffer.limit()) {
            return this;
        }
        return new ArrayWrappingBytes(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return new MutableArrayWrappingBytes(this.toArray());
    }

    @Override
    public byte[] toArray() {
        if (!this.byteBuffer.hasArray()) {
            return super.toArray();
        }
        int arrayOffset = this.byteBuffer.arrayOffset();
        return Arrays.copyOfRange(this.byteBuffer.array(), arrayOffset + this.offset, arrayOffset + this.offset + this.length);
    }

    @Override
    public byte[] toArrayUnsafe() {
        if (!this.byteBuffer.hasArray()) {
            return this.toArray();
        }
        byte[] array = this.byteBuffer.array();
        if (array.length != this.length || this.byteBuffer.arrayOffset() != 0) {
            return this.toArray();
        }
        return array;
    }
}

