/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.security.codegen;

import colesico.framework.assist.codegen.ArrayCodegen;
import colesico.framework.assist.codegen.CodegenException;
import colesico.framework.assist.codegen.model.AnnotationAssist;
import colesico.framework.assist.codegen.model.ParserElement;
import colesico.framework.security.RequireAuthority;
import colesico.framework.security.RequirePrincipal;
import colesico.framework.security.SecurityInterceptor;
import colesico.framework.security.SecurityKit;
import colesico.framework.service.codegen.model.InterceptionElement;
import colesico.framework.service.codegen.model.ProxyFieldElement;
import colesico.framework.service.codegen.model.ProxyMethodElement;
import colesico.framework.service.codegen.modulator.Modulator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class SecurityModulator
extends Modulator {
    public static final String SEQURITY_KIT_FIELD = "securityKit";

    public void onProxyMethod(ProxyMethodElement proxyMethod) {
        super.onProxyMethod(proxyMethod);
        AnnotationAssist requirePrincipal = proxyMethod.getOriginMethod().getAnnotation(RequirePrincipal.class);
        AnnotationAssist requireAuthority = proxyMethod.getOriginMethod().getAnnotation(RequireAuthority.class);
        if (requirePrincipal != null || requireAuthority != null) {
            if (proxyMethod.isPlain()) {
                throw CodegenException.of().message("To use @" + RequirePrincipal.class.getSimpleName() + " or @" + RequireAuthority.class.getSimpleName() + " method should not be plain method").element((ParserElement)proxyMethod.getOriginMethod()).build();
            }
        } else {
            return;
        }
        FieldSpec fieldSpec = FieldSpec.builder((TypeName)ClassName.get(SecurityKit.class), (String)SEQURITY_KIT_FIELD, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        ProxyFieldElement fieldElement = new ProxyFieldElement(fieldSpec).inject();
        this.service.addField(fieldElement);
        if (requireAuthority != null) {
            CodeBlock.Builder paramCode = CodeBlock.builder();
            paramCode.add("new $T[]{", new Object[]{ClassName.get(String.class)});
            String[] authorityIds = ((RequireAuthority)requireAuthority.unwrap()).value();
            ArrayCodegen ac = new ArrayCodegen();
            for (String authorityId : authorityIds) {
                ac.add("$S", new Object[]{authorityId});
            }
            paramCode.add(ac.toFormat(), ac.toValues());
            paramCode.add("}", new Object[0]);
            CodeBlock.Builder handlerCode = CodeBlock.builder();
            handlerCode.add("(($T)$N)::$N", new Object[]{ClassName.get(SecurityInterceptor.class), SEQURITY_KIT_FIELD, "interceptRequireAuthority"});
            proxyMethod.addInterception("AUTHORIZATION", new InterceptionElement(handlerCode.build(), paramCode.build()));
        } else {
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            codeBlock.add("(($T)$N)::$N", new Object[]{ClassName.get(SecurityInterceptor.class), SEQURITY_KIT_FIELD, "interceptRequirePrincipal"});
            proxyMethod.addInterception("AUTHORIZATION", new InterceptionElement(codeBlock.build()));
        }
    }
}

