/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.security;

import colesico.framework.security.AuthorityRequiredException;
import colesico.framework.security.Principal;
import colesico.framework.security.PrincipalRequiredException;

public interface SecurityKit {
    public static final String REQUIRE_AUTHORITY_METHOD = "requireAuthority";
    public static final String REQUIRE_PRINCIPAL_METHOD = "requirePrincipal";

    public <P extends Principal> P getPrincipal();

    public void setPrincipal(Principal var1);

    public boolean hasAuthority(String ... var1);

    default public void requirePrincipal() {
        Object principal = this.getPrincipal();
        if (principal == null) {
            throw new PrincipalRequiredException();
        }
    }

    default public void requireAuthority(String ... authorityId) {
        Object principal = this.getPrincipal();
        if (principal == null) {
            throw new AuthorityRequiredException(authorityId);
        }
        if (!this.hasAuthority(authorityId)) {
            throw new AuthorityRequiredException(authorityId);
        }
    }
}

