/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.security;

import colesico.framework.ioc.key.Key;
import colesico.framework.ioc.key.TypeKey;
import colesico.framework.ioc.scope.ThreadScope;
import colesico.framework.security.Principal;
import colesico.framework.security.SecurityInterceptor;
import colesico.framework.service.InvocationContext;
import colesico.framework.teleapi.DataPort;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultSecurityKit
implements SecurityInterceptor {
    protected final ThreadScope threadScope;
    protected final Provider<DataPort> dataPortProv;

    @Inject
    public DefaultSecurityKit(ThreadScope threadScope, Provider<DataPort> dataPortProv) {
        this.threadScope = threadScope;
        this.dataPortProv = dataPortProv;
    }

    protected Principal principalReadControl(DataPort<Object, Object> port) {
        return (Principal)port.read(Principal.class, null);
    }

    protected void principalWriteControl(DataPort<Object, Object> port, Principal principal) {
        port.write(Principal.class, (Object)principal, null);
    }

    protected boolean hasAuthorityControl(Principal principal, String ... authorityId) {
        return principal != null;
    }

    @Override
    public final <P extends Principal> P getPrincipal() {
        PrincipalHolder holder = (PrincipalHolder)this.threadScope.get(PrincipalHolder.SCOPE_KEY);
        if (holder != null) {
            return (P)holder.getPrincipal();
        }
        DataPort port = (DataPort)this.dataPortProv.get();
        Principal principal = this.principalReadControl((DataPort<Object, Object>)port);
        this.threadScope.put(PrincipalHolder.SCOPE_KEY, (Object)new PrincipalHolder(principal));
        return (P)principal;
    }

    @Override
    public final void setPrincipal(Principal principal) {
        DataPort port = (DataPort)this.dataPortProv.get();
        this.principalWriteControl((DataPort<Object, Object>)port, principal);
    }

    @Override
    public final boolean hasAuthority(String ... authorityId) {
        Object principal = this.getPrincipal();
        return this.hasAuthorityControl((Principal)principal, authorityId);
    }

    @Override
    public final Object interceptRequirePrincipal(InvocationContext context) {
        this.requirePrincipal();
        return context.proceed();
    }

    @Override
    public final Object interceptRequireAuthority(InvocationContext context) {
        this.requireAuthority((String[])context.getInterception().getParameters());
        return context.proceed();
    }

    public static final class PrincipalHolder {
        public static final Key<PrincipalHolder> SCOPE_KEY = new TypeKey(PrincipalHolder.class);
        private final Principal principal;

        public PrincipalHolder(Principal principal) {
            this.principal = principal;
        }

        public Principal getPrincipal() {
            return this.principal;
        }
    }
}

