/*
 * Copyright © 2014-2020 Vladlen V. Larionov and others as noted.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package colesico.framework.security;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * Principal default implementation
 *
 * @author Vladlen Larionov
 */
public final class DefaultPrincipal implements Principal {

    private static final long serialVersionUID = 1L;

    private final String id;

    public DefaultPrincipal(String id) {
        if (StringUtils.isBlank(id)) {
            throw new RuntimeException("Principal ID is blank");
        }
        this.id = id;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DefaultPrincipal that = (DefaultPrincipal) o;
        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "DefaultPrincipal{id=" + id + '}';
    }
}
