/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.security.assist;

import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACSignature {
    public static final String HmacMD5 = "HmacMD5";
    public static final String HmacSHA1 = "HmacSHA1";
    public static final String HmacSHA224 = "HmacSHA224";
    public static final String HmacSHA256 = "HmacSHA256";
    public static final String HmacSHA384 = "HmacSHA384";
    public static final String HmacSHA512 = "HmacSHA512";
    public static final String HmacSHA512_224 = "HmacSHA512/224";
    public static final String HmacSHA512_256 = "HmacSHA512/256";
    public static final String HmacSHA3_224 = "HmacSHA3-224";
    public static final String HmacSHA3_256 = "HmacSHA3-256";
    public static final String HmacSHA3_384 = "HmacSHA3-384";
    public static final String HmacSHA3_512 = "HmacSHA3-512";

    public static byte[] sign(String algorithm, byte[] value, byte[] key) {
        try {
            Mac hashAlg = Mac.getInstance(algorithm);
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            hashAlg.init(keySpec);
            byte[] result = hashAlg.doFinal(value);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(String algorithm, byte[] value, byte[] key, byte[] signature) {
        byte[] nsignature = HMACSignature.sign(algorithm, value, key);
        return MessageDigest.isEqual(nsignature, signature);
    }
}

