/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.restlet.teleapi.reader;

import colesico.framework.http.HttpContext;
import colesico.framework.http.HttpMethod;
import colesico.framework.restlet.teleapi.RestletJsonConverter;
import colesico.framework.restlet.teleapi.RestletTRContext;
import colesico.framework.restlet.teleapi.reader.ObjectReader;
import colesico.framework.router.RouterContext;
import colesico.framework.telehttp.Origin;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public final class JsonReader
extends ObjectReader {
    protected final RestletJsonConverter jsonConverter;

    @Inject
    public JsonReader(Provider<RouterContext> routerContextProv, Provider<HttpContext> httpContextProv, RestletJsonConverter jsonConverter) {
        super(routerContextProv, httpContextProv);
        this.jsonConverter = jsonConverter;
    }

    public Object read(RestletTRContext context) {
        boolean useInputStream;
        HttpContext httpContext = (HttpContext)this.httpContextProv.get();
        HttpMethod requestMethod = httpContext.getRequest().getRequestMethod();
        Origin origin = context.getOriginFacade().getOrigin();
        boolean bl = useInputStream = !(!origin.equals((Object)Origin.BODY) && !origin.equals((Object)Origin.AUTO) || !requestMethod.equals((Object)HttpMethod.HTTP_METHOD_POST) && !requestMethod.equals((Object)HttpMethod.HTTP_METHOD_PUT) && !requestMethod.equals((Object)HttpMethod.HTTP_METHOD_PATCH));
        if (useInputStream) {
            Object t;
            block12: {
                InputStream is = httpContext.getRequest().getInputStream();
                try {
                    t = this.jsonConverter.fromJson(is, context.getValueType());
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                is.close();
            }
            return t;
        }
        try {
            String strValue = context.getString((RouterContext)this.routerContextProv.get(), httpContext.getRequest());
            if (StringUtils.isBlank((CharSequence)strValue)) {
                return null;
            }
            return this.jsonConverter.fromJson(strValue, context.getValueType());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

