/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.restlet.teleapi;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public interface RestletJsonConverter {
    public <T> String toJson(T var1);

    public <T> T fromJson(Reader var1, Type var2);

    default public <T> T fromJson(Reader reader, Class<T> valueClass) {
        return this.fromJson(reader, (Type)valueClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T fromJson(InputStream is, Type valueType) {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            T t = this.fromJson((Reader)reader, valueType);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T fromJson(InputStream is, Class<T> valueClass) {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            T t = this.fromJson((Reader)reader, valueClass);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T fromJson(String json, Type valueType) {
        try (StringReader reader = new StringReader(json);){
            T t = this.fromJson((Reader)reader, valueType);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T fromJson(String json, Class<T> valueClass) {
        try (StringReader reader = new StringReader(json);){
            T t = this.fromJson((Reader)reader, valueClass);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

