/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.restlet.internal;

import colesico.framework.http.HttpContext;
import colesico.framework.ioc.Ioc;
import colesico.framework.ioc.key.ClassedKey;
import colesico.framework.ioc.key.Key;
import colesico.framework.restlet.RestletErrorResponse;
import colesico.framework.restlet.teleapi.RestletDataPort;
import colesico.framework.restlet.teleapi.RestletJsonConverter;
import colesico.framework.restlet.teleapi.RestletTRContext;
import colesico.framework.restlet.teleapi.RestletTWContext;
import colesico.framework.restlet.teleapi.RestletTeleReader;
import colesico.framework.restlet.teleapi.RestletTeleWriter;
import colesico.framework.restlet.teleapi.reader.ObjectReader;
import colesico.framework.restlet.teleapi.writer.ObjectWriter;
import colesico.framework.router.RouterContext;
import java.lang.reflect.Type;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class RestletDataPortImpl
implements RestletDataPort {
    protected final Ioc ioc;
    protected final Provider<HttpContext> httpContextProv;
    protected final Provider<RouterContext> routerContextProv;
    protected final RestletJsonConverter jsonConverter;

    public RestletDataPortImpl(Ioc ioc, Provider<HttpContext> httpContextProv, Provider<RouterContext> routerContextProv, RestletJsonConverter jsonConverter) {
        this.ioc = ioc;
        this.httpContextProv = httpContextProv;
        this.routerContextProv = routerContextProv;
        this.jsonConverter = jsonConverter;
    }

    protected String typeToClassName(Type valueType) {
        if (valueType instanceof Class) {
            return ((Class)valueType).getCanonicalName();
        }
        return valueType.getTypeName();
    }

    public <V> V read(Type valueType, RestletTRContext context) {
        if (context == null) {
            context = new RestletTRContext();
        }
        context.setValueType(valueType);
        RestletTeleReader reader = null;
        if (context.getReaderClass() != null) {
            reader = (RestletTeleReader)((Object)this.ioc.instance(context.getReaderClass()));
        } else {
            reader = (RestletTeleReader)((Object)this.ioc.instanceOrNull((Key)new ClassedKey(RestletTeleReader.class.getCanonicalName(), this.typeToClassName(valueType)), null));
            if (reader == null) {
                reader = (RestletTeleReader)((Object)this.ioc.instance(ObjectReader.class));
            }
        }
        return (V)reader.read((Object)context);
    }

    public <V> void write(Type valueType, V value, RestletTWContext context) {
        RestletTeleWriter writer;
        if (context == null) {
            context = new RestletTWContext();
        }
        if ((writer = context.getWriterClass() != null ? (RestletTeleWriter)((Object)this.ioc.instance(context.getWriterClass())) : (RestletTeleWriter)((Object)this.ioc.instanceOrNull((Key)new ClassedKey(RestletTeleWriter.class.getCanonicalName(), this.typeToClassName(valueType)), null))) == null) {
            writer = (RestletTeleWriter)((Object)this.ioc.instance(ObjectWriter.class));
        }
        writer.write(value, (Object)context);
    }

    @Override
    public void writeError(RestletErrorResponse response, int httpCode) {
        RestletTeleWriter writer = (RestletTeleWriter)((Object)this.ioc.instance(ObjectWriter.class));
        RestletTWContext context = new RestletTWContext();
        context.setHttpCode(httpCode);
        writer.write(response, (Object)context);
    }
}

