/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.restlet.teleapi.writer;

import colesico.framework.http.HttpContext;
import colesico.framework.restlet.teleapi.RestletJsonConverter;
import colesico.framework.restlet.teleapi.RestletTWContext;
import colesico.framework.restlet.teleapi.writer.ObjectWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public final class JsonWriter
extends ObjectWriter {
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    protected final RestletJsonConverter jsonConverter;

    @Inject
    public JsonWriter(Provider<HttpContext> httpContextProv, RestletJsonConverter jsonConverter) {
        super(httpContextProv);
        this.jsonConverter = jsonConverter;
    }

    public void write(Object value, RestletTWContext context) {
        if (value == null) {
            this.getResponse().sendText("", JSON_CONTENT_TYPE, Integer.valueOf(204));
        }
        String json = this.jsonConverter.toJson(value);
        Integer code = context.getHttpCode();
        if (code == null) {
            code = 200;
        }
        this.getResponse().sendData(ByteBuffer.wrap(json.getBytes(StandardCharsets.UTF_8)), JSON_CONTENT_TYPE, code);
    }
}

