/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.restlet.teleapi.gson;

import colesico.framework.ioc.production.Polysupplier;
import colesico.framework.restlet.teleapi.RestletJsonConverter;
import colesico.framework.restlet.teleapi.gson.GsonByteArrayToBase64;
import colesico.framework.restlet.teleapi.gson.GsonLocalDateTime;
import colesico.framework.restlet.teleapi.gson.RestletGsonOptionsPrototype;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import javax.inject.Singleton;

@Singleton
public class GsonConverter
implements RestletJsonConverter {
    protected final Gson gson;

    public GsonConverter(Polysupplier<RestletGsonOptionsPrototype> options) {
        GsonBuilder builder = new GsonBuilder();
        builder.excludeFieldsWithModifiers(new int[]{8, 128, 64}).registerTypeHierarchyAdapter(byte[].class, (Object)new GsonByteArrayToBase64()).registerTypeAdapter(LocalDateTime.class, (Object)new GsonLocalDateTime());
        options.forEach(o -> o.applyOptions(builder), null);
        this.gson = builder.create();
    }

    @Override
    public <T> String toJson(T obj) {
        return this.gson.toJson(obj);
    }

    @Override
    public <T> T fromJson(Reader reader, Type valueType) {
        return (T)this.gson.fromJson(reader, valueType);
    }
}

