/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.restlet.internal;

import colesico.framework.http.HttpContext;
import colesico.framework.http.HttpException;
import colesico.framework.http.HttpRequest;
import colesico.framework.ioc.production.Polysupplier;
import colesico.framework.ioc.scope.ThreadScope;
import colesico.framework.restlet.RestletConfigPrototype;
import colesico.framework.restlet.RestletErrorResponse;
import colesico.framework.restlet.teleapi.RestletDataPort;
import colesico.framework.restlet.teleapi.RestletRequestListener;
import colesico.framework.restlet.teleapi.RestletResponseListener;
import colesico.framework.restlet.teleapi.RestletTIContext;
import colesico.framework.restlet.teleapi.RestletTeleDriver;
import colesico.framework.security.AuthorityRequiredException;
import colesico.framework.security.PrincipalRequiredException;
import colesico.framework.service.ApplicationException;
import colesico.framework.teleapi.DataPort;
import colesico.framework.teleapi.MethodInvoker;
import colesico.framework.validation.ValidationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestletTeleDriverImpl
implements RestletTeleDriver {
    public static final String X_REQUESTED_WITH_HEADER = "X-Requested-With";
    public static final String X_REQUESTED_WITH_HEADER_VAL = "XMLHttpRequest";
    protected final Logger log = LoggerFactory.getLogger(RestletTeleDriver.class);
    protected final RestletConfigPrototype config;
    protected final ThreadScope threadScope;
    protected final Provider<HttpContext> httpContextProv;
    protected final RestletDataPort dataPort;
    protected final Polysupplier<RestletRequestListener> reqListenerSup;
    protected final Polysupplier<RestletResponseListener> respListenerSup;

    @Inject
    public RestletTeleDriverImpl(RestletConfigPrototype config, ThreadScope threadScope, Provider<HttpContext> httpContextProv, RestletDataPort dataPort, Polysupplier<RestletRequestListener> reqListenerSup, Polysupplier<RestletResponseListener> respListenerSup) {
        this.config = config;
        this.threadScope = threadScope;
        this.httpContextProv = httpContextProv;
        this.dataPort = dataPort;
        this.reqListenerSup = reqListenerSup;
        this.respListenerSup = respListenerSup;
    }

    public <S> void invoke(S service, MethodInvoker<S, RestletDataPort> invoker, RestletTIContext invCtx) {
        this.threadScope.put(DataPort.SCOPE_KEY, (Object)this.dataPort);
        HttpContext httpCtx = (HttpContext)this.httpContextProv.get();
        try {
            this.invokeImpl(service, invoker, invCtx, httpCtx);
        }
        catch (Exception ex) {
            this.handleCommonError(ex, 500, httpCtx);
        }
    }

    protected void guardCSFR(HttpRequest httpRequest) {
        String xRequestedWith = (String)httpRequest.getHeaders().get(X_REQUESTED_WITH_HEADER);
        if (!X_REQUESTED_WITH_HEADER_VAL.equals(xRequestedWith)) {
            throw new ApplicationException("Http header 'X-Requested-With=XMLHttpRequest' required");
        }
    }

    protected void notifyRequestListener(HttpContext context, Object service) {
        if (this.reqListenerSup.isNotEmpty()) {
            this.reqListenerSup.forEach(s -> s.onRequest(context, this.dataPort, service), null);
        }
    }

    protected void notifyResponseListener(HttpContext context) {
        if (this.respListenerSup.isNotEmpty()) {
            this.respListenerSup.forEach(s -> s.onResponse(context, this.dataPort), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S> void invokeImpl(S service, MethodInvoker binder, RestletTIContext invCtx, HttpContext httpCtx) {
        HttpRequest httpRequest = httpCtx.getRequest();
        try {
            this.notifyRequestListener(httpCtx, service);
            if (this.config.enableCSFRProtection().booleanValue()) {
                this.guardCSFR(httpRequest);
            }
            binder.invoke(service, (DataPort)this.dataPort);
        }
        catch (HttpException hex) {
            if (hex.getCause() != null) {
                if (hex.getCause() instanceof ValidationException) {
                    this.handleValidationError((ValidationException)hex.getCause(), hex.getHttpCode(), httpCtx);
                } else {
                    this.handleCommonError(hex.getCause(), hex.getHttpCode(), httpCtx);
                }
            } else {
                this.handleCommonError(hex, hex.getHttpCode(), httpCtx);
            }
        }
        catch (ValidationException vex) {
            this.handleValidationError(vex, 400, httpCtx);
        }
        catch (PrincipalRequiredException prex) {
            this.handleCommonError(prex, 401, httpCtx);
        }
        catch (AuthorityRequiredException arex) {
            this.handleCommonError(arex, 403, httpCtx);
        }
        finally {
            this.notifyResponseListener(httpCtx);
        }
    }

    protected String getMessage(Throwable ex) {
        Throwable e = ex;
        ArrayList<String> messages = new ArrayList<String>();
        int depth = 0;
        while (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            messages.add(message);
            if (e.getCause() == e) {
                e = null;
                continue;
            }
            if (depth++ < 8) {
                e = e.getCause();
                continue;
            }
            e = null;
        }
        return StringUtils.join(messages, (String)"; ");
    }

    protected void handleCommonError(Throwable ex, int httpCode, HttpContext context) {
        String errMsg = MessageFormat.format("Restlet error: {0}", ExceptionUtils.getRootCauseMessage((Throwable)ex));
        if (ex instanceof ApplicationException) {
            this.log.warn(errMsg, ex);
        } else {
            this.log.error(errMsg, ex);
        }
        RestletErrorResponse response = new RestletErrorResponse(context.getRequest().getRequestURI(), (Integer)httpCode, this.getMessage(ex));
        this.dataPort.writeError(response, httpCode);
    }

    protected void handleValidationError(ValidationException ex, int httpCode, HttpContext context) {
        String errMsg = MessageFormat.format("Restlet validation error: {0}", ExceptionUtils.getRootCauseMessage((Throwable)ex));
        this.log.warn(errMsg);
        RestletErrorResponse response = new RestletErrorResponse(context.getRequest().getRequestURI(), (Integer)httpCode, ex.getIssue());
        this.dataPort.writeError(response, httpCode);
    }
}

