/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile;

import colesico.framework.ioc.key.Key;
import colesico.framework.ioc.key.TypeKey;
import colesico.framework.ioc.scope.ThreadScope;
import colesico.framework.profile.Profile;
import colesico.framework.profile.ProfileKit;
import colesico.framework.teleapi.DataPort;
import javax.inject.Provider;

public class DefaultProfileKit
implements ProfileKit {
    protected final ThreadScope threadScope;
    protected final Provider<DataPort> dataPortProv;

    public DefaultProfileKit(ThreadScope threadScope, Provider<DataPort> dataPortProv) {
        this.threadScope = threadScope;
        this.dataPortProv = dataPortProv;
    }

    protected InputControlResult controlInputProfile(Profile profile) {
        return InputControlResult.accept(profile);
    }

    protected Profile controlOutputProfile(Profile profile) {
        return profile;
    }

    @Override
    public final <P extends Profile> P getProfile() {
        ProfileHolder holder = (ProfileHolder)this.threadScope.get(ProfileHolder.SCOPE_KEY);
        if (holder != null) {
            return (P)holder.profile();
        }
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(null));
        DataPort port = (DataPort)this.dataPortProv.get();
        Profile profile = (Profile)port.read(Profile.class);
        InputControlResult result = this.controlInputProfile(profile);
        profile = result.profile;
        if (!result.accepted) {
            port.write((Object)profile, Profile.class);
        }
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(profile));
        return (P)profile;
    }

    @Override
    public final void setProfile(Profile profile) {
        DataPort port = (DataPort)this.dataPortProv.get();
        profile = this.controlOutputProfile(profile);
        port.write((Object)profile, Profile.class);
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(profile));
    }

    public record InputControlResult(Profile profile, boolean accepted) {
        public static InputControlResult reset(Profile profile) {
            return new InputControlResult(profile, false);
        }

        public static InputControlResult accept(Profile profile) {
            return new InputControlResult(profile, true);
        }
    }

    public record ProfileHolder(Profile profile) {
        public static final Key<ProfileHolder> SCOPE_KEY = new TypeKey(ProfileHolder.class);
    }
}

