/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile;

import colesico.framework.ioc.key.Key;
import colesico.framework.ioc.key.TypeKey;
import colesico.framework.ioc.scope.ThreadScope;
import colesico.framework.profile.Profile;
import colesico.framework.profile.ProfileKit;
import colesico.framework.teleapi.DataPort;
import javax.inject.Provider;

public class DefaultProfileKit
implements ProfileKit {
    protected final ThreadScope threadScope;
    protected final Provider<DataPort> dataPortProv;

    public DefaultProfileKit(ThreadScope threadScope, Provider<DataPort> dataPortProv) {
        this.threadScope = threadScope;
        this.dataPortProv = dataPortProv;
    }

    protected boolean isInputControlRequired(Profile profile) {
        return false;
    }

    protected InputControlResult controlInputProfile(Profile profile) {
        throw new UnsupportedOperationException("Default control not implemented");
    }

    protected boolean isOutputControlRequired(Profile profile) {
        return false;
    }

    protected Profile controlOutputProfile(Profile profile) {
        throw new UnsupportedOperationException("Default control not implemented");
    }

    @Override
    public final <P extends Profile> P getProfile() {
        ProfileHolder holder = (ProfileHolder)this.threadScope.get(ProfileHolder.SCOPE_KEY);
        if (holder != null) {
            return (P)holder.getProfile();
        }
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(null));
        DataPort port = (DataPort)this.dataPortProv.get();
        Profile profile = (Profile)port.read(Profile.class);
        if (this.isInputControlRequired(profile)) {
            InputControlResult res = this.controlInputProfile(profile);
            profile = res.getProfile();
            if (res.isUpdateOnClient()) {
                port.write((Object)profile, Profile.class);
            }
        }
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(profile));
        return (P)profile;
    }

    @Override
    public final void setProfile(Profile profile) {
        DataPort port = (DataPort)this.dataPortProv.get();
        if (this.isOutputControlRequired(profile)) {
            profile = this.controlOutputProfile(profile);
        }
        port.write((Object)profile, Profile.class);
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(profile));
    }

    public static final class ProfileHolder {
        public static final Key<ProfileHolder> SCOPE_KEY = new TypeKey(ProfileHolder.class);
        private final Profile profile;

        public ProfileHolder(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }
    }

    public static final class InputControlResult {
        private Profile profile = null;
        private boolean updateOnClient = false;

        public InputControlResult() {
        }

        public InputControlResult(Profile profile, boolean updateOnClient) {
            this.profile = profile;
            this.updateOnClient = updateOnClient;
        }

        public InputControlResult(Profile profile) {
            this.profile = profile;
            this.updateOnClient = true;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public void setProfile(Profile profile) {
            this.profile = profile;
        }

        public boolean isUpdateOnClient() {
            return this.updateOnClient;
        }

        public void setUpdateOnClient(boolean updateOnClient) {
            this.updateOnClient = updateOnClient;
        }
    }
}

