/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile;

import colesico.framework.profile.ObjectiveQualifiers;
import colesico.framework.profile.SubjectQualifiers;
import java.util.HashMap;
import java.util.Map;

public final class Localizer {
    private static final String ANY_VALUE = "*";
    private final Node rootNode = new Node();

    public void addLocalization(SubjectQualifiers qualifiers) {
        Node lastNode = this.provideLastNode(qualifiers);
        lastNode.setQualifiers(qualifiers);
    }

    public SubjectQualifiers localize(ObjectiveQualifiers qualifiers) {
        Node curNode = this.rootNode;
        for (String q : qualifiers) {
            Node node = curNode.getNext(q);
            if (node == null && (node = curNode.getNext(ANY_VALUE)) == null) {
                return null;
            }
            curNode = node;
        }
        return curNode.getQualifiers();
    }

    private Node provideLastNode(SubjectQualifiers qualifiers) {
        Node curNode = this.rootNode;
        for (String qualifierValue : qualifiers) {
            if (qualifierValue == null) {
                qualifierValue = ANY_VALUE;
            }
            curNode = curNode.provideNext(qualifierValue);
        }
        return curNode;
    }

    private static final class Node {
        private SubjectQualifiers qualifiers;
        private Map<String, Node> nextNodes;

        private Node() {
        }

        public Node getNext(String name) {
            return this.nextNodes == null ? null : this.nextNodes.get(name);
        }

        public Node provideNext(String name) {
            if (this.nextNodes == null) {
                this.nextNodes = new HashMap<String, Node>();
            }
            return this.nextNodes.computeIfAbsent(name, key -> new Node());
        }

        public SubjectQualifiers getQualifiers() {
            return this.qualifiers;
        }

        public void setQualifiers(SubjectQualifiers qualifiers) {
            this.qualifiers = qualifiers;
        }

        public String toString() {
            return "Localizer.Node{qualifiers=" + this.qualifiers + "}";
        }
    }
}

