/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile;

import colesico.framework.profile.QualifiersDefinition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public final class SubjectQualifiers
implements Iterable<String> {
    private final String[] values;

    public static SubjectQualifiers fromMap(Map<String, String> qualifiersMap, QualifiersDefinition standard) {
        if (qualifiersMap == null || qualifiersMap.isEmpty()) {
            throw new RuntimeException("Qualifiers is empty");
        }
        Set<String> canonicityNames = Set.of(standard.getNames());
        for (String name : qualifiersMap.keySet()) {
            if (canonicityNames.contains(name)) continue;
            throw new RuntimeException("Undefined qualifier name: " + name);
        }
        String[] qualifiersArr = new String[standard.getSize()];
        for (int i = 0; i < standard.getSize(); ++i) {
            String name = standard.getName(i);
            qualifiersArr[i] = name != null ? qualifiersMap.get(name) : null;
        }
        return new SubjectQualifiers(qualifiersArr);
    }

    public static SubjectQualifiers fromSpec(String qualifiersSpec, QualifiersDefinition standard) {
        return SubjectQualifiers.fromMap(SubjectQualifiers.parseQualifiersSpec(qualifiersSpec), standard);
    }

    private static Map<String, String> parseQualifiersSpec(String qualifiersSpec) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(qualifiersSpec, ";");
        while (st.hasMoreElements()) {
            String qualifierSpec = st.nextToken();
            String[] qualifier = SubjectQualifiers.parseQualifierSpec(qualifierSpec);
            result.put(qualifier[0], qualifier[1]);
        }
        return result;
    }

    private static String[] parseQualifierSpec(String qualifierSpec) {
        StringTokenizer st = new StringTokenizer(qualifierSpec, "=");
        String name = StringUtils.trim((String)st.nextToken());
        if (!st.hasMoreElements()) {
            throw new RuntimeException("Invalid qualifier specification format: " + qualifierSpec);
        }
        String val = StringUtils.trim((String)st.nextToken());
        return new String[]{name, val};
    }

    public SubjectQualifiers(String[] values) {
        this.values = values;
    }

    public String[] getValues() {
        return this.values;
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.stream(this.values).iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        for (String q : this.values) {
            action.accept(q);
        }
    }

    public String toSuffix(char separator) {
        StringBuilder sb = new StringBuilder();
        for (String value : this.values) {
            if (value == null) continue;
            sb.append(separator).append(value);
        }
        return sb.toString();
    }

    public String toString() {
        return "ResourceQualifiers{values=" + Arrays.toString(this.values) + "}";
    }
}

