/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public final class Localizer {
    private static final String ANY_VALUE = "*";
    private final Node rootNode = new Node();

    public void add(String[] qualifierNames, String ... qualifiersSetSpec) {
        for (String qssItem : qualifiersSetSpec) {
            LinkedHashMap<String, String> qualifiersMap = this.parseQualifiersSetSpec(qssItem);
            this.checkNames(qualifierNames, qualifiersMap);
            Node lastNode = this.provideLastNode(qualifierNames, qualifiersMap);
            lastNode.setQualifiers(this.toQualifiers(qualifiersMap));
        }
    }

    public String[] localize(String[] masterQualifiers) {
        Node curNode = this.rootNode;
        for (String q : masterQualifiers) {
            Node node = curNode.getNext(q);
            if (node == null && (node = curNode.getNext(ANY_VALUE)) == null) {
                return null;
            }
            curNode = node;
        }
        return curNode.getQualifiers();
    }

    private String[] toQualifiers(LinkedHashMap<String, String> qualifiersMap) {
        String[] result = new String[qualifiersMap.size()];
        int i = 0;
        for (Map.Entry<String, String> q : qualifiersMap.entrySet()) {
            result[i++] = q.getValue();
        }
        return result;
    }

    private Node provideLastNode(String[] qualifierNames, Map<String, String> qualifiersMap) {
        Node curNode = this.rootNode;
        for (String qualifierName : qualifierNames) {
            String qualifierValue = qualifiersMap.get(qualifierName);
            if (qualifierValue == null) {
                qualifierValue = ANY_VALUE;
            }
            curNode = curNode.provideNext(qualifierValue);
        }
        return curNode;
    }

    private LinkedHashMap<String, String> parseQualifiersSetSpec(String qualifiersSetSpec) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(qualifiersSetSpec, ";");
        while (st.hasMoreElements()) {
            String qualifierSpec = st.nextToken();
            QualifierSpec qualifier = this.parseQualifierSpec(qualifierSpec);
            result.put(qualifier.getKey(), qualifier.getValue());
        }
        return result;
    }

    private void checkNames(String[] qualifierNames, Map<String, String> qualifiersMap) {
        HashSet<String> namesSet = new HashSet<String>();
        namesSet.addAll(Arrays.asList(qualifierNames));
        for (String name : qualifiersMap.keySet()) {
            if (namesSet.contains(name)) continue;
            throw new RuntimeException("Invalid qualifier name: " + name);
        }
    }

    private QualifierSpec parseQualifierSpec(String qualifierSpec) {
        StringTokenizer st = new StringTokenizer(qualifierSpec, "=");
        String name = StringUtils.trim((String)st.nextToken());
        if (!st.hasMoreElements()) {
            throw new RuntimeException("Invalid qualifier specification format: " + qualifierSpec);
        }
        String val = StringUtils.trim((String)st.nextToken());
        return new QualifierSpec(name, val);
    }

    private static final class Node {
        private String[] qualifiers;
        private Map<String, Node> nextNodes;

        private Node() {
        }

        public Node getNext(String name) {
            return this.nextNodes == null ? null : this.nextNodes.get(name);
        }

        public Node provideNext(String name) {
            if (this.nextNodes == null) {
                this.nextNodes = new HashMap<String, Node>();
            }
            return this.nextNodes.computeIfAbsent(name, key -> new Node());
        }

        public String[] getQualifiers() {
            return this.qualifiers;
        }

        public void setQualifiers(String[] qualifiers) {
            this.qualifiers = qualifiers;
        }

        public String toString() {
            return "Localizer.Node{qualifiers=" + Arrays.toString(this.qualifiers) + "}";
        }
    }

    private static class QualifierSpec {
        private final String key;
        private final String value;

        public QualifierSpec(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

