/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile.internal;

import colesico.framework.profile.DefaultProfile;
import colesico.framework.profile.Profile;
import colesico.framework.profile.teleapi.ProfileTeleAssist;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class ProfileTeleAssistImpl
implements ProfileTeleAssist<DefaultProfile> {
    @Override
    public byte[] serialize(DefaultProfile profile) {
        StringBuilder sb = new StringBuilder();
        sb.append(profile.getLocale().getLanguage());
        sb.append('|');
        sb.append(profile.getLocale().getCountry());
        try {
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DefaultProfile deserialize(byte[] profileBytes) {
        try {
            String localeStr = new String(profileBytes, "UTF-8");
            String[] localeItems = StringUtils.split((String)localeStr, (String)"|");
            Locale locale = new Locale(localeItems[0], localeItems[1]);
            return new DefaultProfile(locale);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Profile buildDefault(Locale locale) {
        return new DefaultProfile(locale);
    }
}

