/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.profile;

import colesico.framework.ioc.Key;
import colesico.framework.ioc.ThreadScope;
import colesico.framework.ioc.TypeKey;
import colesico.framework.profile.Profile;
import colesico.framework.profile.ProfileKit;
import colesico.framework.teleapi.DataPort;
import javax.inject.Provider;

public class DefaultProfileKit
implements ProfileKit {
    protected final ThreadScope threadScope;
    protected final Provider<DataPort> dataPortProv;

    public DefaultProfileKit(ThreadScope threadScope, Provider<DataPort> dataPortProv) {
        this.threadScope = threadScope;
        this.dataPortProv = dataPortProv;
    }

    protected Profile profileReadControl(DataPort<Object, Object> port) {
        return (Profile)port.readForClass(Profile.class, null);
    }

    protected void profileWriteControl(DataPort port, Profile profile) {
        port.writeForClass(Profile.class, (Object)profile, null);
    }

    @Override
    public final <P extends Profile> P getProfile() {
        ProfileHolder holder = (ProfileHolder)this.threadScope.get(ProfileHolder.SCOPE_KEY);
        if (holder != null) {
            return (P)holder.getProfile();
        }
        DataPort port = (DataPort)this.dataPortProv.get();
        Profile profile = this.profileReadControl((DataPort<Object, Object>)port);
        this.threadScope.put(ProfileHolder.SCOPE_KEY, (Object)new ProfileHolder(profile));
        return (P)profile;
    }

    @Override
    public final void setProfile(Profile profile) {
        DataPort port = (DataPort)this.dataPortProv.get();
        this.profileWriteControl(port, profile);
    }

    public static final class ProfileHolder {
        public static final Key<ProfileHolder> SCOPE_KEY = new TypeKey(ProfileHolder.class);
        private final Profile profile;

        public ProfileHolder(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }
    }
}

