/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.pebble.internal;

import colesico.framework.pebble.internal.T9nDictionaryNode;
import colesico.framework.translation.TranslationKit;
import io.pebbletemplates.pebble.error.ParserException;
import io.pebbletemplates.pebble.lexer.Token;
import io.pebbletemplates.pebble.lexer.TokenStream;
import io.pebbletemplates.pebble.node.RenderableNode;
import io.pebbletemplates.pebble.parser.Parser;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import org.apache.commons.lang3.StringUtils;

public final class T9nDictionaryParser
implements TokenParser {
    public static final String DEFAULT_DICT_NAME = "messages";
    private final TranslationKit translationKit;

    public T9nDictionaryParser(TranslationKit translationKit) {
        this.translationKit = translationKit;
    }

    public String getTag() {
        return "t9nDictionary";
    }

    public RenderableNode parse(Token token, Parser parser) throws ParserException {
        String dictName;
        String basePath;
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        token = stream.next();
        if (token.test(Token.Type.STRING)) {
            basePath = token.getValue();
            if (StringUtils.isBlank((CharSequence)basePath)) {
                throw new ParserException(null, "Empty translation dictionary base path", lineNumber, parser.getStream().getFilename());
            }
        } else {
            throw new ParserException(null, "Translation dictionary base path expected", lineNumber, parser.getStream().getFilename());
        }
        token = stream.next();
        if (token.test(Token.Type.STRING)) {
            dictName = token.getValue();
            if (StringUtils.isBlank((CharSequence)dictName)) {
                dictName = DEFAULT_DICT_NAME;
            }
            stream.next();
        } else {
            dictName = DEFAULT_DICT_NAME;
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new T9nDictionaryNode(lineNumber, this.translationKit, dictName, basePath);
    }
}

