/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.pebble;

import colesico.framework.http.HttpContext;
import colesico.framework.http.HttpResponse;
import colesico.framework.ioc.production.Polysupplier;
import colesico.framework.pebble.PebbleOptionsPrototype;
import colesico.framework.pebble.internal.FrameworkExtension;
import colesico.framework.pebble.internal.PebbleTemplateLoader;
import colesico.framework.weblet.HtmlRenderer;
import colesico.framework.weblet.ViewResponse;
import colesico.framework.weblet.teleapi.WebletTWContext;
import colesico.framework.weblet.teleapi.writer.ViewWriter;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class PebbleTemplater
extends ViewWriter
implements HtmlRenderer {
    public static final String MODEL_VAR = "vm";
    private final PebbleEngine pebbleEngine;

    public PebbleTemplater(Provider<HttpContext> httpContextProv, PebbleTemplateLoader tmplLoader, FrameworkExtension frameworkExtension, Polysupplier<PebbleOptionsPrototype> optionsSup) {
        super(httpContextProv);
        PebbleEngine.Builder builder = new PebbleEngine.Builder().loader((Loader)tmplLoader).extension(new Extension[]{frameworkExtension}).autoEscaping(true).defaultEscapingStrategy("html").cacheActive(true);
        optionsSup.forEach(options -> options.applyOptions(builder), null);
        this.pebbleEngine = builder.build();
    }

    public <M> Writer evaluate(String templatePath, M viewModel) {
        StringWriter writer = new StringWriter();
        HashMap<String, M> context = new HashMap<String, M>();
        context.put(MODEL_VAR, viewModel);
        try {
            PebbleTemplate compiledTemplate = this.pebbleEngine.getTemplate(templatePath);
            compiledTemplate.evaluate((Writer)writer, context);
            return writer;
        }
        catch (PebbleException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(ViewResponse viewResponse, WebletTWContext context) {
        Writer writer = this.evaluate(viewResponse.getVewName(), viewResponse.getModel());
        HttpResponse httpResponse = ((HttpContext)this.httpContextProv.get()).getResponse();
        httpResponse.sendText(writer.toString(), "text/html; charset=utf-8", Integer.valueOf(200));
    }

    public String render(String templateName, Object model) {
        Writer writer = this.evaluate(templateName, model);
        return writer.toString();
    }
}

