/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.pebble.internal;

import colesico.framework.ioc.Ioc;
import colesico.framework.pebble.internal.GetBeanFunction;
import colesico.framework.pebble.internal.GetClassedBeanFunction;
import colesico.framework.pebble.internal.GetNamedBeanFunction;
import colesico.framework.pebble.internal.T9nDictionaryParser;
import colesico.framework.pebble.internal.T9nFilter;
import colesico.framework.pebble.internal.T9nFunction;
import colesico.framework.translation.TranslationKit;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FrameworkExtension
extends AbstractExtension {
    private final TranslationKit t9n;
    private final Ioc ioc;

    @Inject
    public FrameworkExtension(TranslationKit t9n, Ioc ioc) {
        this.t9n = t9n;
        this.ioc = ioc;
    }

    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("t9n", new T9nFilter());
        return filters;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("getBean", new GetBeanFunction(this.ioc));
        functions.put("getNamedBean", new GetNamedBeanFunction(this.ioc));
        functions.put("getClassedBean", new GetClassedBeanFunction(this.ioc));
        functions.put("t9n", new T9nFunction());
        return functions;
    }

    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>();
        tokenParsers.add(new T9nDictionaryParser(this.t9n));
        return tokenParsers;
    }
}

