/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.pebble;

import colesico.framework.htmlrenderer.HtmlRenderer;
import colesico.framework.ioc.Polysupplier;
import colesico.framework.pebble.PebbleOptionsPrototype;
import colesico.framework.pebble.internal.FrameworkExtension;
import colesico.framework.pebble.internal.PebbleTemplateLoader;
import colesico.framework.weblet.HtmlResponse;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PebbleRenderer
implements HtmlRenderer<String> {
    public static final String MODEL_VAR = "vm";
    private final PebbleEngine pebbleEngine;

    @Inject
    public PebbleRenderer(PebbleTemplateLoader tmplLoader, FrameworkExtension frameworkExtension, Polysupplier<PebbleOptionsPrototype> optionsSup) {
        PebbleEngine.Builder builder = new PebbleEngine.Builder().loader((Loader)tmplLoader).extension(new Extension[]{frameworkExtension}).autoEscaping(true).defaultEscapingStrategy("html").cacheActive(true);
        optionsSup.forEach(options -> options.applyOptions(builder), null);
        this.pebbleEngine = builder.build();
    }

    public final <M> HtmlResponse render(String templatePath, M model) {
        Writer writer = this.evaluate(templatePath, model);
        return HtmlResponse.of((String)writer.toString());
    }

    public <M> Writer evaluate(String templatePath, M viewModel) {
        StringWriter writer = new StringWriter();
        HashMap<String, M> context = new HashMap<String, M>();
        context.put(MODEL_VAR, viewModel);
        try {
            PebbleTemplate compiledTemplate = this.pebbleEngine.getTemplate(templatePath);
            compiledTemplate.evaluate((Writer)writer, context);
            return writer;
        }
        catch (PebbleException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

