/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.pebble.internal;

import colesico.framework.resource.ResourceKit;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.utils.PathUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PebbleTemplateLoader
implements Loader<String> {
    protected final ResourceKit resourceKit;
    protected final Logger logger = LoggerFactory.getLogger(PebbleTemplateLoader.class);
    private String suffix = ".html";
    private String charset = "UTF-8";

    @Inject
    public PebbleTemplateLoader(ResourceKit resourceKit) {
        this.resourceKit = resourceKit;
    }

    public Reader getReader(String templatePath) throws LoaderException {
        String resourcePath = this.getResourcePath(templatePath);
        BufferedReader reader = null;
        try {
            Enumeration resources = this.resourceKit.getURLs(resourcePath);
            while (resources.hasMoreElements()) {
                URL resource = (URL)resources.nextElement();
                if (reader != null) {
                    this.logger.warn("Duplicate template for " + resourcePath + " ignored: " + resource);
                    continue;
                }
                InputStreamReader isr = new InputStreamReader(resource.openStream(), this.charset);
                reader = new BufferedReader(isr);
                this.logger.debug("Template " + resourcePath + " located: " + resource);
            }
            if (reader == null) {
                throw new RuntimeException("Template not found: " + resourcePath);
            }
        }
        catch (Exception e) {
            throw new LoaderException((Throwable)e, "Error loading template: " + templatePath);
        }
        return reader;
    }

    protected String getResourcePath(String templatePath) {
        Object resourcePath = this.resourceKit.evaluate(templatePath);
        if (!StringUtils.endsWith((CharSequence)resourcePath, (CharSequence)this.suffix)) {
            resourcePath = (String)resourcePath + this.suffix;
        }
        resourcePath = this.resourceKit.rewrite((String)resourcePath);
        return resourcePath;
    }

    public void setCharset(String s) {
        this.charset = s;
    }

    public void setPrefix(String s) {
    }

    public void setSuffix(String s) {
        this.suffix = s;
    }

    public String resolveRelativePath(String relativePath, String anchorPath) {
        return PathUtils.resolveRelativePath((String)relativePath, (String)anchorPath, (char)'/');
    }

    public String createCacheKey(String s) {
        return s;
    }
}

