/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.LogWriter;
import net.codinux.log.config.LogAppenderFieldsConfig;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lnet/codinux/log/Log4j2LogAppenderBase;", "Lorg/apache/logging/log4j/core/appender/AbstractAppender;", "appenderName", "", "logWriter", "Lnet/codinux/log/LogWriter;", "(Ljava/lang/String;Lnet/codinux/log/LogWriter;)V", "config", "Lnet/codinux/log/config/LogAppenderFieldsConfig;", "getConfig", "()Lnet/codinux/log/config/LogAppenderFieldsConfig;", "eventSupportsInstant", "", "getEventSupportsInstant", "()Z", "isAppenderEnabled", "getLogWriter", "()Lnet/codinux/log/LogWriter;", "append", "", "event", "Lorg/apache/logging/log4j/core/LogEvent;", "convertInstant", "Lnet/dankito/datetime/Instant;", "instant", "Lorg/apache/logging/log4j/core/time/Instant;", "Log4j2LogAppenderBase"})
public class Log4j2LogAppenderBase
extends AbstractAppender {
    @NotNull
    private final LogWriter logWriter;
    private final boolean isAppenderEnabled;
    @NotNull
    private final LogAppenderFieldsConfig config;
    private final boolean eventSupportsInstant;

    public Log4j2LogAppenderBase(@NotNull String appenderName, @NotNull LogWriter logWriter) {
        boolean bl;
        Log4j2LogAppenderBase log4j2LogAppenderBase;
        Intrinsics.checkNotNullParameter((Object)appenderName, (String)"appenderName");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        super(appenderName, null, null, true, Property.EMPTY_ARRAY);
        this.logWriter = logWriter;
        this.isAppenderEnabled = this.getLogWriter().getConfig().getEnabled();
        this.config = this.getLogWriter().getConfig().getFields();
        Log4j2LogAppenderBase log4j2LogAppenderBase2 = this;
        try {
            log4j2LogAppenderBase = log4j2LogAppenderBase2;
            LogEvent.class.getDeclaredMethod("getInstant", new Class[0]);
            bl = true;
        }
        catch (Throwable throwable) {
            log4j2LogAppenderBase = log4j2LogAppenderBase2;
            bl = false;
        }
        log4j2LogAppenderBase.eventSupportsInstant = bl;
    }

    @NotNull
    protected LogWriter getLogWriter() {
        return this.logWriter;
    }

    protected boolean isAppenderEnabled() {
        return this.isAppenderEnabled;
    }

    @NotNull
    protected LogAppenderFieldsConfig getConfig() {
        return this.config;
    }

    protected boolean getEventSupportsInstant() {
        return this.eventSupportsInstant;
    }

    public void append(@Nullable LogEvent event) {
        if (this.isAppenderEnabled() && event != null) {
            String string;
            net.dankito.datetime.Instant instant;
            LogWriter logWriter = this.getLogWriter();
            if (this.getEventSupportsInstant()) {
                Instant instant2 = event.getInstant();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"getInstant(...)");
                instant = this.convertInstant(instant2);
            } else {
                instant = net.dankito.datetime.Instant.Companion.ofEpochMilli(event.getTimeMillis());
            }
            String string2 = event.getLevel().name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
            String string3 = event.getMessage().getFormattedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFormattedMessage(...)");
            String string4 = this.getConfig().getLogsLoggerName() ? event.getLoggerName() : null;
            String string5 = this.getConfig().getLogsThreadName() ? event.getThreadName() : null;
            Throwable throwable = this.getConfig().getLogsException() ? event.getThrown() : null;
            Map map = this.getConfig().getLogsMdc() ? event.getContextData().toMap() : null;
            if (this.getConfig().getLogsMarker()) {
                Marker marker = event.getMarker();
                string = marker != null ? marker.getName() : null;
            } else {
                string = null;
            }
            LogWriter.DefaultImpls.writeRecord$default((LogWriter)logWriter, (net.dankito.datetime.Instant)instant, (String)string2, (String)string3, (String)string4, (String)string5, (Throwable)throwable, (Map)map, (String)string, null, (int)256, null);
        }
    }

    @NotNull
    protected net.dankito.datetime.Instant convertInstant(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return new net.dankito.datetime.Instant(instant.getEpochSecond(), instant.getNanoOfSecond());
    }
}

