/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log;

import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.JBossLoggingExtensionsKt;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0004J\u001f\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\n\u00a8\u0006\u0010"}, d2={"Lnet/codinux/log/JBossLoggingUtil;", "", "()V", "colorConsoleHandler", "Lorg/jboss/logmanager/handlers/ConsoleHandler;", "consoleHandler", "formatter", "Ljava/util/logging/Formatter;", "patternConsoleHandler", "registerLogHandler", "", "handler", "", "Ljava/util/logging/Handler;", "([Ljava/util/logging/Handler;)V", "useJBossLoggingAsJavaUtilLoggingManager", "JBossLoggingAppenderBase"})
public final class JBossLoggingUtil {
    @NotNull
    public static final JBossLoggingUtil INSTANCE = new JBossLoggingUtil();

    private JBossLoggingUtil() {
    }

    public final void useJBossLoggingAsJavaUtilLoggingManager() {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
    }

    public final void registerLogHandler(Handler ... handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        LogManager logManager = org.jboss.logmanager.LogManager.getLogManager();
        Intrinsics.checkNotNullExpressionValue((Object)logManager, (String)"getLogManager()");
        JBossLoggingExtensionsKt.addHandlerToRootLogger(logManager, Arrays.copyOf(handler, handler.length));
    }

    @NotNull
    public final ConsoleHandler consoleHandler(@NotNull Formatter formatter) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        return new ConsoleHandler(formatter);
    }

    public static /* synthetic */ ConsoleHandler consoleHandler$default(JBossLoggingUtil jBossLoggingUtil, Formatter formatter, int n, Object object) {
        if ((n & 1) != 0) {
            formatter = new SimpleFormatter();
        }
        return jBossLoggingUtil.consoleHandler(formatter);
    }

    @NotNull
    public final ConsoleHandler patternConsoleHandler() {
        return this.consoleHandler((Formatter)new PatternFormatter());
    }

    @NotNull
    public final ConsoleHandler colorConsoleHandler() {
        return this.consoleHandler((Formatter)new ColorPatternFormatter());
    }
}

