/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch.errorhandler;

import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0013\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lnet/codinux/log/elasticsearch/errorhandler/JavaUtilLogErrorHandler;", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "()V", "loggerClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "loggerName", "", "(Ljava/lang/String;)V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "logError", "", "message", "e", "", "logInfo", "JavaUtilLogElasticsearchLogger"})
public class JavaUtilLogErrorHandler
implements ErrorHandler {
    private final Logger log;

    public JavaUtilLogErrorHandler(@NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        this.log = Logger.getLogger(loggerName);
    }

    public JavaUtilLogErrorHandler() {
        this(JavaUtilLogErrorHandler.class);
    }

    public JavaUtilLogErrorHandler(@NotNull Class<?> loggerClass) {
        Intrinsics.checkNotNullParameter(loggerClass, (String)"loggerClass");
        String string = loggerClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loggerClass.name");
        this(string);
    }

    protected Logger getLog() {
        return this.log;
    }

    public void logError(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().log(Level.SEVERE, message, e);
    }

    public void logInfo(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().info(message);
    }

    public void logError(@NotNull String message) {
        ErrorHandler.DefaultImpls.logError((ErrorHandler)this, (String)message);
    }
}

