/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch;

import java.util.logging.LogManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.PropertiesFilePropertiesProvider;
import net.codinux.log.elasticsearch.PropertyProviderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lnet/codinux/log/elasticsearch/JavaUtilLogPropertyProvider;", "Lnet/codinux/log/elasticsearch/PropertyProviderBase;", "()V", "fallbackProvider", "getFallbackProvider", "()Lnet/codinux/log/elasticsearch/PropertyProviderBase;", "logManager", "Ljava/util/logging/LogManager;", "getLogManager", "()Ljava/util/logging/LogManager;", "getProperty", "", "propertyName", "JavaUtilLogElasticsearchLogger"})
public class JavaUtilLogPropertyProvider
extends PropertyProviderBase {
    @NotNull
    private final LogManager logManager;
    @NotNull
    private final PropertyProviderBase fallbackProvider;

    public JavaUtilLogPropertyProvider() {
        LogManager logManager = LogManager.getLogManager();
        Intrinsics.checkNotNullExpressionValue((Object)logManager, (String)"getLogManager()");
        this.logManager = logManager;
        this.fallbackProvider = (PropertyProviderBase)new PropertiesFilePropertiesProvider();
    }

    @NotNull
    protected LogManager getLogManager() {
        return this.logManager;
    }

    @NotNull
    protected PropertyProviderBase getFallbackProvider() {
        return this.fallbackProvider;
    }

    @Nullable
    public String getProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getLogManager().getProperty(propertyName);
        return string == null ? this.getFallbackProvider().getProperty(propertyName) : string;
    }
}

