/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch;

import java.net.InetAddress;
import java.time.Instant;
import java.util.Arrays;
import java.util.logging.Handler;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.codinux.log.elasticsearch.ElasticsearchLogHandler;
import net.codinux.log.elasticsearch.JavaUtilLogPropertyProvider;
import net.codinux.log.elasticsearch.LogRecord;
import net.codinux.log.elasticsearch.LoggerSettings;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.JavaUtilLogErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lnet/codinux/log/elasticsearch/JavaUtilLogElasticsearchLogHandler;", "Ljava/util/logging/Handler;", "settings", "Lnet/codinux/log/elasticsearch/LoggerSettings;", "errorHandler", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "(Lnet/codinux/log/elasticsearch/LoggerSettings;Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;)V", "elasticsearchLogHandler", "Lnet/codinux/log/elasticsearch/ElasticsearchLogHandler;", "getElasticsearchLogHandler", "()Lnet/codinux/log/elasticsearch/ElasticsearchLogHandler;", "close", "", "flush", "mapRecord", "Lnet/codinux/log/elasticsearch/LogRecord;", "record", "Ljava/util/logging/LogRecord;", "publish", "JavaUtilLogElasticsearchLogger"})
public class JavaUtilLogElasticsearchLogHandler
extends Handler {
    @NotNull
    private final ElasticsearchLogHandler elasticsearchLogHandler;

    @JvmOverloads
    public JavaUtilLogElasticsearchLogHandler(@NotNull LoggerSettings settings, @NotNull ErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        this.elasticsearchLogHandler = new ElasticsearchLogHandler(settings, errorHandler);
    }

    public /* synthetic */ JavaUtilLogElasticsearchLogHandler(LoggerSettings loggerSettings, ErrorHandler errorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            loggerSettings = new JavaUtilLogPropertyProvider().extractSettings();
        }
        if ((n & 2) != 0) {
            errorHandler = new JavaUtilLogErrorHandler();
        }
        this(loggerSettings, errorHandler);
    }

    @NotNull
    protected ElasticsearchLogHandler getElasticsearchLogHandler() {
        return this.elasticsearchLogHandler;
    }

    @Override
    public void publish(@Nullable java.util.logging.LogRecord record) {
        if (record != null && this.isLoggable(record)) {
            this.getElasticsearchLogHandler().handle(this.mapRecord(record));
        }
    }

    @NotNull
    protected LogRecord mapRecord(@NotNull java.util.logging.LogRecord record) {
        boolean bl;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        String message = null;
        message = record.getMessage() == null ? "" : record.getMessage();
        String threadName = Thread.currentThread().getName();
        String hostName = InetAddress.getLocalHost().getHostName();
        if (record.getParameters() != null) {
            object = StringCompanionObject.INSTANCE;
            string = record.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.message");
            Object[] objectArray = record.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"record.parameters");
            Object[] objectArray2 = objectArray;
            objectArray2 = Arrays.copyOf(objectArray2, objectArray2.length);
            bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            message = string2;
        }
        if ((object = record.getThrown()) != null) {
            string = object;
            boolean bl2 = false;
            bl = false;
            String exception = string;
            boolean bl3 = false;
            message = message + ": " + ((Throwable)((Object)exception)).getMessage();
        }
        object = message;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message");
        Object object2 = object;
        object = record.getInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.instant");
        Object object3 = object;
        object = record.getLevel().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.level.name");
        Object object4 = object;
        object = record.getLoggerName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.loggerName");
        Intrinsics.checkNotNullExpressionValue((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullExpressionValue((Object)hostName, (String)"hostName");
        return new LogRecord((String)object2, (Instant)object3, (String)object4, (String)object, threadName, hostName, record.getThrown(), null);
    }

    @Override
    public void flush() {
        this.getElasticsearchLogHandler().flush();
    }

    @Override
    public void close() {
        this.getElasticsearchLogHandler().close();
    }

    @JvmOverloads
    public JavaUtilLogElasticsearchLogHandler(@NotNull LoggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(settings, null, 2, null);
    }

    @JvmOverloads
    public JavaUtilLogElasticsearchLogHandler() {
        this(null, null, 3, null);
    }
}

