/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.net.InetAddress;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.kubernetes.KubernetesInfo;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0014J\u001e\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\n0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfoRetriever;", "", "()V", "retrieveKubernetesInfo", "Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfo;", "namespace", "", "podName", "podIp", "retrieveKubernetesInfoAsync", "", "callback", "Lkotlin/Function1;", "Companion", "ElasticsearchLoggerBase"})
public class KubernetesInfoRetriever {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final DateTimeFormatter StartTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Logger log = LoggerFactory.getLogger(KubernetesInfoRetriever.class);

    public void retrieveKubernetesInfoAsync(@NotNull Function1<? super KubernetesInfo, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(callback, this){
            final /* synthetic */ Function1<KubernetesInfo, Unit> $callback;
            final /* synthetic */ KubernetesInfoRetriever this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$callback.invoke((Object)this.this$0.retrieveKubernetesInfo());
            }
        }), (int)31, null);
    }

    @Nullable
    public KubernetesInfo retrieveKubernetesInfo() {
        try {
            File namespaceFile = new File("/run/secrets/kubernetes.io/serviceaccount/namespace");
            if (!namespaceFile.exists()) {
                log.info("Not running in a Kubernetes environment, file '/run/secrets/kubernetes.io/serviceaccount/namespace' does not exist.");
                return null;
            }
            String namespace = FilesKt.readText$default((File)namespaceFile, null, (int)1, null);
            InetAddress localHost = InetAddress.getLocalHost();
            String podName = localHost.getHostName();
            String podIp = localHost.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)podName, (String)"podName");
            Intrinsics.checkNotNullExpressionValue((Object)podIp, (String)"podIp");
            return this.retrieveKubernetesInfo(namespace, podName, podIp);
        }
        catch (Exception e) {
            log.error("Could not retrieve pod info, no cluster or container info will be added to logs", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected KubernetesInfo retrieveKubernetesInfo(@NotNull String namespace, @NotNull String podName, @NotNull String podIp) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)podName, (String)"podName");
        Intrinsics.checkNotNullParameter((Object)podIp, (String)"podIp");
        String containerName = null;
        Object podIp2 = null;
        podIp2 = podIp;
        String nodeIp = null;
        String nodeName = null;
        Object startTime = null;
        String string = Instant.now().atOffset(ZoneOffset.UTC).format(StartTimeFormat);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"now().atOffset(ZoneOffset.UTC).format(StartTimeFormat)");
        startTime = string;
        String containerId = null;
        String imageName = null;
        String imageId = null;
        int restartCount = 0;
        String uid = null;
        String clusterName = null;
        Map labels = null;
        boolean bl = false;
        labels = MapsKt.emptyMap();
        Object annotations = null;
        boolean bl2 = false;
        annotations = MapsKt.emptyMap();
        LoggerFactory.getLogger(HttpLoggingInterceptor.class);
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        List list = client.getHttpClient().networkInterceptors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client.httpClient.networkInterceptors()");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HttpLoggingInterceptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpLoggingInterceptor it = (HttpLoggingInterceptor)element$iv;
            boolean bl3 = false;
            it.setLevel(HttpLoggingInterceptor.Level.NONE);
        }
        PodResource podResource = (PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName);
        Pod pod = podResource == null ? null : (Pod)podResource.get();
        podResource = pod;
        if (podResource != null) {
            boolean bl4;
            boolean bl5;
            Container container;
            Object object2;
            boolean bl6;
            boolean bl7;
            ObjectMeta objectMeta;
            object = podResource;
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$retrieveKubernetesInfo_u24lambda_u2d6 = object;
            boolean bl10 = false;
            ObjectMeta objectMeta2 = $this$retrieveKubernetesInfo_u24lambda_u2d6.getMetadata();
            if (objectMeta2 != null) {
                Object object3;
                Map map;
                boolean bl11;
                objectMeta = objectMeta2;
                bl7 = false;
                bl6 = false;
                ObjectMeta $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d1 = objectMeta;
                boolean bl12 = false;
                uid = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d1.getUid();
                clusterName = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d1.getClusterName();
                object2 = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d1.getLabels();
                if (object2 == null) {
                    bl11 = false;
                    map = MapsKt.emptyMap();
                } else {
                    map = object2;
                }
                labels = map;
                object2 = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d1.getAnnotations();
                if (object2 == null) {
                    bl11 = false;
                    object3 = MapsKt.emptyMap();
                } else {
                    object3 = object2;
                }
                annotations = object3;
            }
            objectMeta2 = $this$retrieveKubernetesInfo_u24lambda_u2d6.getSpec();
            if (objectMeta2 != null) {
                Container container2;
                objectMeta = objectMeta2;
                bl7 = false;
                bl6 = false;
                ObjectMeta $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d3 = objectMeta;
                boolean bl13 = false;
                nodeName = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d3.getNodeName();
                object2 = $this$retrieveKubernetesInfo_u24lambda_u2d6.getSpec().getContainers();
                if (object2 != null && (container2 = (Container)CollectionsKt.firstOrNull((List)object2)) != null) {
                    container = container2;
                    bl5 = false;
                    bl4 = false;
                    Container container3 = container;
                    boolean bl14 = false;
                    containerName = container3.getName();
                    imageName = container3.getImage();
                }
            }
            objectMeta2 = $this$retrieveKubernetesInfo_u24lambda_u2d6.getStatus();
            if (objectMeta2 != null) {
                ContainerStatus containerStatus;
                objectMeta = objectMeta2;
                bl7 = false;
                bl6 = false;
                ObjectMeta $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d5 = objectMeta;
                boolean bl15 = false;
                object2 = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d5.getPodIP();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"podIP");
                podIp2 = object2;
                nodeIp = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d5.getHostIP();
                object2 = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d5.getStartTime();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.startTime");
                startTime = object2;
                object2 = $this$retrieveKubernetesInfo_u24lambda_u2d6_u24lambda_u2d5.getContainerStatuses();
                if (object2 != null && (containerStatus = (ContainerStatus)CollectionsKt.firstOrNull((List)object2)) != null) {
                    container = containerStatus;
                    bl5 = false;
                    bl4 = false;
                    Container containerStatus2 = container;
                    boolean bl16 = false;
                    containerName = containerStatus2.getName();
                    containerId = containerStatus2.getContainerID();
                    imageName = containerStatus2.getImage();
                    imageId = containerStatus2.getImageID();
                    Integer n = containerStatus2.getRestartCount();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"containerStatus.restartCount");
                    restartCount = ((Number)n).intValue();
                }
            }
        }
        return new KubernetesInfo(namespace, podName, (String)podIp2, (String)startTime, uid, restartCount, containerName, containerId, imageName, imageId, nodeIp, nodeName, clusterName, labels, (Map<String, String>)annotations);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfoRetriever$Companion;", "", "()V", "StartTimeFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "ElasticsearchLoggerBase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

