/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch.errorhandler;

import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.StdErrErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\"\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lnet/codinux/log/elasticsearch/errorhandler/OnlyOnceErrorHandler;", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "wrappedErrorHandler", "(Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;)V", "handledErrors", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Class;", "", "getHandledErrors", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "getWrappedErrorHandler", "()Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "logError", "", "message", "", "e", "logInfo", "ElasticsearchLoggerBase"})
public class OnlyOnceErrorHandler
implements ErrorHandler {
    @NotNull
    private final ErrorHandler wrappedErrorHandler;
    @NotNull
    private final CopyOnWriteArrayList<Class<? extends Throwable>> handledErrors;

    @JvmOverloads
    public OnlyOnceErrorHandler(@NotNull ErrorHandler wrappedErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)wrappedErrorHandler, (String)"wrappedErrorHandler");
        this.wrappedErrorHandler = wrappedErrorHandler;
        this.handledErrors = new CopyOnWriteArrayList();
    }

    public /* synthetic */ OnlyOnceErrorHandler(ErrorHandler errorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            errorHandler = new StdErrErrorHandler();
        }
        this(errorHandler);
    }

    @NotNull
    protected ErrorHandler getWrappedErrorHandler() {
        return this.wrappedErrorHandler;
    }

    @NotNull
    protected CopyOnWriteArrayList<Class<? extends Throwable>> getHandledErrors() {
        return this.handledErrors;
    }

    @Override
    public void logError(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (e != null) {
            if (this.getHandledErrors().contains(e.getClass())) {
                return;
            }
            this.getHandledErrors().add(e.getClass());
        }
        this.getWrappedErrorHandler().logError(message, e);
    }

    @Override
    public void logInfo(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getWrappedErrorHandler().logInfo(message);
    }

    @Override
    public void logError(@NotNull String message) {
        ErrorHandler.DefaultImpls.logError(this, message);
    }

    @JvmOverloads
    public OnlyOnceErrorHandler() {
        this(null, 1, null);
    }
}

