/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch.errorhandler;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.StdErrErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lnet/codinux/log/elasticsearch/errorhandler/LogPerPeriodErrorHandler;", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "period", "Ljava/time/Duration;", "wrappedErrorHandler", "exceptionsToLogEachTime", "", "Ljava/lang/Class;", "", "(Ljava/time/Duration;Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;Ljava/util/Collection;)V", "getExceptionsToLogEachTime", "()Ljava/util/Collection;", "handledErrors", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/time/Instant;", "getHandledErrors", "()Ljava/util/concurrent/ConcurrentHashMap;", "getPeriod", "()Ljava/time/Duration;", "getWrappedErrorHandler", "()Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "logError", "", "message", "", "e", "logInfo", "ElasticsearchLoggerBase"})
public class LogPerPeriodErrorHandler
implements ErrorHandler {
    @NotNull
    private final Duration period;
    @NotNull
    private final ErrorHandler wrappedErrorHandler;
    @NotNull
    private final Collection<Class<? extends Throwable>> exceptionsToLogEachTime;
    @NotNull
    private final ConcurrentHashMap<Class<? extends Throwable>, Instant> handledErrors;

    @JvmOverloads
    public LogPerPeriodErrorHandler(@NotNull Duration period, @NotNull ErrorHandler wrappedErrorHandler, @NotNull Collection<? extends Class<? extends Throwable>> exceptionsToLogEachTime) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)wrappedErrorHandler, (String)"wrappedErrorHandler");
        Intrinsics.checkNotNullParameter(exceptionsToLogEachTime, (String)"exceptionsToLogEachTime");
        this.period = period;
        this.wrappedErrorHandler = wrappedErrorHandler;
        this.exceptionsToLogEachTime = exceptionsToLogEachTime;
        this.handledErrors = new ConcurrentHashMap();
    }

    public /* synthetic */ LogPerPeriodErrorHandler(Duration duration, ErrorHandler errorHandler, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorHandler = new StdErrErrorHandler();
        }
        if ((n & 4) != 0) {
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        }
        this(duration, errorHandler, collection);
    }

    @NotNull
    protected Duration getPeriod() {
        return this.period;
    }

    @NotNull
    protected ErrorHandler getWrappedErrorHandler() {
        return this.wrappedErrorHandler;
    }

    @NotNull
    protected Collection<Class<? extends Throwable>> getExceptionsToLogEachTime() {
        return this.exceptionsToLogEachTime;
    }

    @NotNull
    protected ConcurrentHashMap<Class<? extends Throwable>, Instant> getHandledErrors() {
        return this.handledErrors;
    }

    @Override
    public void logError(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (e != null && !this.getExceptionsToLogEachTime().contains(e.getClass())) {
            Instant errorLastLoggedAt = this.getHandledErrors().get(e.getClass());
            if (errorLastLoggedAt != null && this.getPeriod().compareTo(Duration.between(errorLastLoggedAt, Instant.now())) > 0) {
                return;
            }
            this.getHandledErrors().put(e.getClass(), Instant.now());
        }
        this.getWrappedErrorHandler().logError(message, e);
    }

    @Override
    public void logInfo(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getWrappedErrorHandler().logInfo(message);
    }

    @Override
    public void logError(@NotNull String message) {
        ErrorHandler.DefaultImpls.logError(this, message);
    }

    @JvmOverloads
    public LogPerPeriodErrorHandler(@NotNull Duration period, @NotNull ErrorHandler wrappedErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)wrappedErrorHandler, (String)"wrappedErrorHandler");
        this(period, wrappedErrorHandler, null, 4, null);
    }

    @JvmOverloads
    public LogPerPeriodErrorHandler(@NotNull Duration period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this(period, null, null, 6, null);
    }
}

