/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch.converter;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import org.elasticsearch.common.Strings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/codinux/log/elasticsearch/converter/ElasticsearchIndexNameConverter;", "", "invalidCharactersReplacement", "", "(Ljava/lang/String;)V", "getInvalidCharactersReplacement", "()Ljava/lang/String;", "buildIndexName", "indexNamePattern", "errorHandler", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "removeInvalidCharacters", "indexName", "resolvePatterns", "Companion", "ElasticsearchLoggerBase"})
public class ElasticsearchIndexNameConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String invalidCharactersReplacement;
    @NotNull
    public static final String DefaultInvalidCharacterReplacement = "_";
    @NotNull
    private static final List<Character> InvalidIndexNameStartCharacters;
    @NotNull
    private static final Set<Character> InvalidIndexNameCharacters;
    @NotNull
    private static final Regex UpperCaseRegex;
    @NotNull
    private static final Regex DatePatternRegex;

    @JvmOverloads
    public ElasticsearchIndexNameConverter(@NotNull String invalidCharactersReplacement) {
        Intrinsics.checkNotNullParameter((Object)invalidCharactersReplacement, (String)"invalidCharactersReplacement");
        this.invalidCharactersReplacement = invalidCharactersReplacement;
    }

    public /* synthetic */ ElasticsearchIndexNameConverter(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = DefaultInvalidCharacterReplacement;
        }
        this(string);
    }

    @NotNull
    protected String getInvalidCharactersReplacement() {
        return this.invalidCharactersReplacement;
    }

    @NotNull
    public String buildIndexName(@NotNull String indexNamePattern, @NotNull ErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)indexNamePattern, (String)"indexNamePattern");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        String indexName = this.resolvePatterns(indexNamePattern, errorHandler);
        return this.removeInvalidCharacters(indexName, errorHandler);
    }

    @NotNull
    protected String removeInvalidCharacters(@NotNull String indexName, @NotNull ErrorHandler errorHandler) {
        int n;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        String validIndexName = null;
        validIndexName = indexName;
        if (Intrinsics.areEqual((Object)validIndexName, (Object)".") || Intrinsics.areEqual((Object)validIndexName, (Object)"..")) {
            String replacement = this.getInvalidCharactersReplacement().length() == 1 && InvalidIndexNameStartCharacters.contains(Character.valueOf(this.getInvalidCharactersReplacement().charAt(0))) ? "logs" : this.getInvalidCharactersReplacement();
            errorHandler.logError("The index name may not be '.' or '..'. Replacing it with '" + replacement + "'.");
            validIndexName = StringsKt.replace$default((String)validIndexName, (String)validIndexName, (String)replacement, (boolean)false, (int)4, null);
        }
        if (!Strings.validFileName((String)indexName) || StringsKt.contains$default((CharSequence)indexName, (char)':', (boolean)false, (int)2, null)) {
            Iterable $this$forEach$iv = InvalidIndexNameCharacters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                char invalidCharacter = ((Character)element$iv).charValue();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)validIndexName, (char)invalidCharacter, (boolean)false, (int)2, null)) continue;
                errorHandler.logInfo("Elasticsearch index names may not contain '" + invalidCharacter + "'. Replacing it with '" + this.getInvalidCharactersReplacement() + "'.");
                validIndexName = StringsKt.replace$default((String)validIndexName, (String)String.valueOf(invalidCharacter), (String)this.getInvalidCharactersReplacement(), (boolean)false, (int)4, null);
            }
        }
        while (true) {
            charSequence = validIndexName;
            n = 0;
            if (!(charSequence.length() > 0) || !InvalidIndexNameStartCharacters.contains(Character.valueOf(validIndexName.charAt(0)))) break;
            errorHandler.logInfo("Elasticsearch index names may not start with '" + validIndexName.charAt(0) + "'. Replacing it with '" + this.getInvalidCharactersReplacement() + "'.");
            charSequence = validIndexName;
            n = 1;
            boolean bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)((String)charSequence2).substring(n), (String)"(this as java.lang.String).substring(startIndex)");
        }
        if (UpperCaseRegex.containsMatchIn((CharSequence)validIndexName)) {
            StringBuilder stringBuilder = new StringBuilder().append("Index name '").append(validIndexName).append("' may not contain upper case characters. Converting it to '");
            charSequence = validIndexName;
            n = 0;
            CharSequence charSequence3 = charSequence;
            if (charSequence3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence3).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            errorHandler.logInfo(stringBuilder.append(string).append("'.").toString());
            charSequence = validIndexName;
            n = 0;
            CharSequence charSequence4 = charSequence;
            if (charSequence4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)charSequence4).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            validIndexName = string2;
        }
        return validIndexName;
    }

    @NotNull
    protected String resolvePatterns(@NotNull String indexNamePattern, @NotNull ErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)indexNamePattern, (String)"indexNamePattern");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        MatchResult matchResult = Regex.find$default((Regex)DatePatternRegex, (CharSequence)indexNamePattern, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            boolean bl2 = false;
            MatchResult match = matchResult2;
            boolean bl3 = false;
            if (match.getGroupValues().size() > 1) {
                String datePattern = (String)match.getGroupValues().get(1);
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
                    String string = match.getValue();
                    String string2 = formatter.format(Instant.now().atOffset(ZoneOffset.UTC));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatter.format(Instant.now().atOffset(ZoneOffset.UTC))");
                    return StringsKt.replace$default((String)indexNamePattern, (String)string, (String)string2, (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    errorHandler.logError("Could not convert date pattern '" + datePattern + "' from index name '" + indexNamePattern + "' with java.time.format.DateTimeFormatter", e);
                }
            }
        }
        return indexNamePattern;
    }

    @JvmOverloads
    public ElasticsearchIndexNameConverter() {
        this(null, 1, null);
    }

    @NotNull
    public static final List<Character> getInvalidIndexNameStartCharacters() {
        return Companion.getInvalidIndexNameStartCharacters();
    }

    @NotNull
    public static final Set<Character> getInvalidIndexNameCharacters() {
        return Companion.getInvalidIndexNameCharacters();
    }

    @NotNull
    public static final Regex getUpperCaseRegex() {
        return Companion.getUpperCaseRegex();
    }

    @NotNull
    public static final Regex getDatePatternRegex() {
        return Companion.getDatePatternRegex();
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('+')};
        InvalidIndexNameStartCharacters = CollectionsKt.listOf((Object[])objectArray);
        UpperCaseRegex = new Regex("[A-Z]");
        DatePatternRegex = new Regex("%date\\{(.+)}");
        Set set = Strings.INVALID_FILENAME_CHARS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"INVALID_FILENAME_CHARS");
        Set invalidCharacters = CollectionsKt.toMutableSet((Iterable)set);
        invalidCharacters.add(Character.valueOf(':'));
        set = Collections.unmodifiableSet(invalidCharacters);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(invalidCharacters)");
        InvalidIndexNameCharacters = set;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lnet/codinux/log/elasticsearch/converter/ElasticsearchIndexNameConverter$Companion;", "", "()V", "DatePatternRegex", "Lkotlin/text/Regex;", "getDatePatternRegex$annotations", "getDatePatternRegex", "()Lkotlin/text/Regex;", "DefaultInvalidCharacterReplacement", "", "InvalidIndexNameCharacters", "", "", "getInvalidIndexNameCharacters$annotations", "getInvalidIndexNameCharacters", "()Ljava/util/Set;", "InvalidIndexNameStartCharacters", "", "getInvalidIndexNameStartCharacters$annotations", "getInvalidIndexNameStartCharacters", "()Ljava/util/List;", "UpperCaseRegex", "getUpperCaseRegex$annotations", "getUpperCaseRegex", "ElasticsearchLoggerBase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Character> getInvalidIndexNameStartCharacters() {
            return InvalidIndexNameStartCharacters;
        }

        @JvmStatic
        public static /* synthetic */ void getInvalidIndexNameStartCharacters$annotations() {
        }

        @NotNull
        public final Set<Character> getInvalidIndexNameCharacters() {
            return InvalidIndexNameCharacters;
        }

        @JvmStatic
        public static /* synthetic */ void getInvalidIndexNameCharacters$annotations() {
        }

        @NotNull
        public final Regex getUpperCaseRegex() {
            return UpperCaseRegex;
        }

        @JvmStatic
        public static /* synthetic */ void getUpperCaseRegex$annotations() {
        }

        @NotNull
        public final Regex getDatePatternRegex() {
            return DatePatternRegex;
        }

        @JvmStatic
        public static /* synthetic */ void getDatePatternRegex$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

