/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.LoggerSettings;
import net.codinux.log.elasticsearch.TimestampResolution;
import net.codinux.log.elasticsearch.TimestampResolutionConverter;
import net.codinux.log.elasticsearch.converter.ElasticsearchIndexNameConverter;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cH\u0014J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0014J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012H&J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lnet/codinux/log/elasticsearch/PropertyProviderBase;", "", "()V", "indexNameConverter", "Lnet/codinux/log/elasticsearch/converter/ElasticsearchIndexNameConverter;", "getIndexNameConverter", "()Lnet/codinux/log/elasticsearch/converter/ElasticsearchIndexNameConverter;", "timestampResolutionConverter", "Lnet/codinux/log/elasticsearch/TimestampResolutionConverter;", "getTimestampResolutionConverter", "()Lnet/codinux/log/elasticsearch/TimestampResolutionConverter;", "extractSettings", "Lnet/codinux/log/elasticsearch/LoggerSettings;", "errorHandler", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "getBooleanProperty", "", "propertyName", "", "defaultValue", "getElasticsearchProperty", "getElasticsearchPropertyOr", "getFieldName", "fieldName", "getIncludeField", "getIntProperty", "", "getLongProperty", "", "getNullableStringProperty", "getProperty", "getTimestampResolution", "Lnet/codinux/log/elasticsearch/TimestampResolution;", "Companion", "ElasticsearchLoggerBase"})
public abstract class PropertyProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElasticsearchIndexNameConverter indexNameConverter = new ElasticsearchIndexNameConverter(null, 1, null);
    @NotNull
    private final TimestampResolutionConverter timestampResolutionConverter = new TimestampResolutionConverter();
    @NotNull
    public static final String FIELD_NAME_KEY = ".name";
    @NotNull
    public static final String INCLUDE_NAME_KEY = ".include";

    @Nullable
    public abstract String getProperty(@NotNull String var1);

    @NotNull
    protected ElasticsearchIndexNameConverter getIndexNameConverter() {
        return this.indexNameConverter;
    }

    @NotNull
    protected TimestampResolutionConverter getTimestampResolutionConverter() {
        return this.timestampResolutionConverter;
    }

    @NotNull
    public LoggerSettings extractSettings(@NotNull ErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        String indexName = this.getIndexNameConverter().buildIndexName(this.getElasticsearchPropertyOr("index", "logs"), errorHandler);
        TimestampResolution timestampResolution = this.getTimestampResolution();
        return new LoggerSettings(this.getBooleanProperty("enable", true), this.getElasticsearchPropertyOr("host", "null"), indexName, this.getFieldName("message", "message"), timestampResolution == null ? LoggerSettings.Companion.getTimestampDefaultResolution() : timestampResolution, this.getFieldName("timestamp", "@timestamp"), this.getIncludeField("level", true), this.getFieldName("level", "level"), this.getIncludeField("logger", true), this.getFieldName("logger", "logger"), this.getIncludeField("loggername", false), this.getFieldName("loggername", "loggername"), this.getIncludeField("thread", true), this.getFieldName("thread", "thread"), this.getIncludeField("hostName", true), this.getFieldName("hostName", "host"), this.getIncludeField("stacktrace", true), this.getFieldName("stacktrace", "stacktrace"), this.getIncludeField("mdc", true), this.getNullableStringProperty("mdcprefix", "mdc"), this.getIncludeField("marker", false), this.getFieldName("marker", "marker"), this.getIncludeField("ndc", false), this.getFieldName("ndc", "ndc"), this.getIncludeField("kubernetes", false), this.getNullableStringProperty("kubernetesprefix", "k8s"), this.getIncludeField("kubernetes-labels", false), this.getNullableStringProperty("kuberneteslabelsprefix", "label"), this.getIncludeField("kubernetes-annotations", false), this.getNullableStringProperty("kubernetesannotationsprefix", "annotation"), this.getIntProperty("maxlogrecordperbatch", 100), this.getIntProperty("maxbufferedlogrecords", 2000), this.getLongProperty("sendlogrecordsperiodmillis", 100L));
    }

    protected boolean getIncludeField(@NotNull String fieldName, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return this.getBooleanProperty(Intrinsics.stringPlus((String)fieldName, (Object)INCLUDE_NAME_KEY), defaultValue);
    }

    @NotNull
    protected String getFieldName(@NotNull String fieldName, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.getElasticsearchProperty(Intrinsics.stringPlus((String)fieldName, (Object)FIELD_NAME_KEY));
        return string == null ? defaultValue : string;
    }

    @Nullable
    protected String getNullableStringProperty(@NotNull String propertyName, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getElasticsearchProperty(propertyName);
        return string == null ? defaultValue : string;
    }

    protected int getIntProperty(@NotNull String propertyName, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getElasticsearchProperty(propertyName);
        if (string == null) {
            n = defaultValue;
        } else {
            int n2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = it;
            boolean bl4 = false;
            n = n2 = Integer.parseInt(string3);
        }
        return n;
    }

    protected long getLongProperty(@NotNull String propertyName, long defaultValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getElasticsearchProperty(propertyName);
        if (string == null) {
            l = defaultValue;
        } else {
            long l2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = it;
            boolean bl4 = false;
            l = l2 = Long.parseLong(string3);
        }
        return l;
    }

    protected boolean getBooleanProperty(@NotNull String propertyName, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getElasticsearchProperty(propertyName);
        if (string == null) {
            bl = defaultValue;
        } else {
            boolean bl2;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string2;
            boolean bl5 = false;
            String string3 = it;
            boolean bl6 = false;
            bl = bl2 = Boolean.parseBoolean(string3);
        }
        return bl;
    }

    @Nullable
    protected TimestampResolution getTimestampResolution() {
        TimestampResolution timestampResolution;
        String string = this.getElasticsearchProperty("timestampresolution");
        if (string == null) {
            timestampResolution = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String value = string2;
            boolean bl3 = false;
            timestampResolution = this.getTimestampResolutionConverter().convert(value);
        }
        return timestampResolution;
    }

    @NotNull
    protected String getElasticsearchPropertyOr(@NotNull String propertyName, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.getElasticsearchProperty(propertyName);
        return string == null ? defaultValue : string;
    }

    @Nullable
    protected String getElasticsearchProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.getProperty(Intrinsics.stringPlus((String)"log.elasticsearch.", (Object)propertyName));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/codinux/log/elasticsearch/PropertyProviderBase$Companion;", "", "()V", "FIELD_NAME_KEY", "", "INCLUDE_NAME_KEY", "ElasticsearchLoggerBase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

