/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch;

import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.PropertyProviderBase;
import net.codinux.log.elasticsearch.errorhandler.StdErrErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/codinux/log/elasticsearch/PropertiesFilePropertiesProvider;", "Lnet/codinux/log/elasticsearch/PropertyProviderBase;", "()V", "properties", "Ljava/util/Properties;", "getProperty", "", "propertyName", "loadPropertiesFile", "", "Companion", "ElasticsearchLoggerBase"})
public class PropertiesFilePropertiesProvider
extends PropertyProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties properties = new Properties();
    @NotNull
    public static final String FILE_NAME = "/logging.properties";

    public PropertiesFilePropertiesProvider() {
        this.loadPropertiesFile();
    }

    protected void loadPropertiesFile() {
        try {
            InputStream inputStream = PropertiesFilePropertiesProvider.class.getResourceAsStream(FILE_NAME);
            Thread thread = Thread.currentThread();
            if (inputStream == null && thread.getContextClassLoader() != null) {
                inputStream = thread.getContextClassLoader().getResourceAsStream(FILE_NAME);
            }
            this.properties.load(inputStream);
        }
        catch (Exception e) {
            new StdErrErrorHandler().logError("Could not read logging properties from /logging.properties", e);
        }
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.properties.getProperty(propertyName);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/codinux/log/elasticsearch/PropertiesFilePropertiesProvider$Companion;", "", "()V", "FILE_NAME", "", "ElasticsearchLoggerBase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

