/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.codinux.log.elasticsearch.LogRecord;
import net.codinux.log.elasticsearch.LogWriter;
import net.codinux.log.elasticsearch.LoggerSettings;
import net.codinux.log.elasticsearch.TimestampResolution;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.OnlyOnceErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.StdErrErrorHandler;
import net.codinux.log.elasticsearch.kubernetes.KubernetesInfo;
import org.apache.http.HttpHost;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 R2\u00020\u0001:\u0001RB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010)H\u0014J$\u0010-\u001a\u00020&2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020)0(2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u001402H\u0014J\b\u00103\u001a\u00020&H\u0016J:\u00104\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020)0(2\u0006\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020\u00142\f\u00107\u001a\b\u0012\u0004\u0012\u00020)08H\u0014J4\u00104\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020)0(2\u0006\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020)H\u0014J\u0010\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u0014H\u0014J\u0016\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001402H\u0014J\u0010\u0010>\u001a\u00020\u00142\u0006\u0010'\u001a\u00020?H\u0014J\u0012\u0010@\u001a\u00020\u00142\b\u0010A\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010B\u001a\u00020\u00142\u0006\u0010'\u001a\u00020?H\u0002J\u0010\u0010C\u001a\u00020\u00142\u0006\u0010'\u001a\u00020?H\u0014J\u0010\u0010D\u001a\u00020\u00142\u0006\u0010E\u001a\u00020FH\u0014J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020)0H2\u0006\u0010'\u001a\u00020?H\u0014J\u001e\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001402H\u0014J\u0016\u0010M\u001a\u00020&2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001402H\u0014J\b\u0010N\u001a\u00020&H\u0014J\b\u0010O\u001a\u00020&H\u0014J\u0016\u0010P\u001a\u00020K2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001402H\u0014J\u0010\u0010Q\u001a\u00020&2\u0006\u0010'\u001a\u00020?H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006S"}, d2={"Lnet/codinux/log/elasticsearch/ElasticsearchLogWriter;", "Lnet/codinux/log/elasticsearch/LogWriter;", "settings", "Lnet/codinux/log/elasticsearch/LoggerSettings;", "errorHandler", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "(Lnet/codinux/log/elasticsearch/LoggerSettings;Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;)V", "getErrorHandler", "()Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "handleRecords", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getHandleRecords", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isClosed", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "recordsQueue", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "getRecordsQueue", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "restClient", "Lorg/elasticsearch/client/RestHighLevelClient;", "getRestClient", "()Lorg/elasticsearch/client/RestHighLevelClient;", "getSettings", "()Lnet/codinux/log/elasticsearch/LoggerSettings;", "timestampFormatter", "Ljava/time/format/DateTimeFormatter;", "getTimestampFormatter", "()Ljava/time/format/DateTimeFormatter;", "workerThread", "Ljava/lang/Thread;", "getWorkerThread", "()Ljava/lang/Thread;", "addIfNotNull", "", "record", "", "", "fieldNamePrefix", "fieldName", "value", "addKubernetesInfoToEsRecord", "esRecord", "info", "Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfo;", "calculateRecordsToSend", "", "close", "conditionallyAdd", "include", "", "valueSupplier", "Lkotlin/Function0;", "convertToEsFieldName", "name", "createBulkRequest", "Lorg/elasticsearch/action/bulk/BulkRequest;", "recordsToSend", "createEsRecordJson", "Lnet/codinux/log/elasticsearch/LogRecord;", "determinePrefix", "prefix", "extractLoggerName", "extractStacktrace", "formatTimestamp", "timestamp", "Ljava/time/Instant;", "mapToEsRecord", "", "reAddFailedItemsToQueue", "response", "Lorg/elasticsearch/action/bulk/BulkResponse;", "sentRecords", "reAddSentItemsToQueue", "sendData", "sendNextBatch", "sendRecords", "writeRecord", "Companion", "ElasticsearchLoggerBase"})
public class ElasticsearchLogWriter
implements LogWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoggerSettings settings;
    @NotNull
    private final ErrorHandler errorHandler;
    @NotNull
    private final CopyOnWriteArrayList<String> recordsQueue;
    @NotNull
    private final RestHighLevelClient restClient;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final AtomicBoolean handleRecords;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final DateTimeFormatter timestampFormatter;
    @NotNull
    private final Thread workerThread;
    @NotNull
    private static final DateTimeFormatter MillisTimestampFormatter;
    @NotNull
    private static final DateTimeFormatter MicrosTimestampFormatter;
    @NotNull
    private static final DateTimeFormatter NanosTimestampFormatter;

    @JvmOverloads
    public ElasticsearchLogWriter(@NotNull LoggerSettings settings, @NotNull ErrorHandler errorHandler) {
        DateTimeFormatter dateTimeFormatter;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        this.settings = settings;
        this.errorHandler = errorHandler;
        this.recordsQueue = new CopyOnWriteArrayList();
        Object object = new HttpHost[]{HttpHost.create((String)this.getSettings().getHost())};
        this.restClient = new RestHighLevelClient(RestClient.builder((HttpHost[])object));
        this.mapper = new ObjectMapper();
        this.handleRecords = new AtomicBoolean(true);
        this.isClosed = new AtomicBoolean(false);
        object = this.getSettings().getTimestampResolution();
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                dateTimeFormatter = MillisTimestampFormatter;
                break;
            }
            case 2: {
                dateTimeFormatter = MicrosTimestampFormatter;
                break;
            }
            case 3: {
                dateTimeFormatter = NanosTimestampFormatter;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.timestampFormatter = dateTimeFormatter;
        this.workerThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Send logs to Elasticsearch", (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ElasticsearchLogWriter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.sendData();
            }
        }), (int)23, null);
        this.getErrorHandler().logInfo("Logging to index '" + this.getSettings().getIndexName() + "' on host " + this.getSettings().getHost());
    }

    public /* synthetic */ ElasticsearchLogWriter(LoggerSettings loggerSettings, ErrorHandler errorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorHandler = new OnlyOnceErrorHandler(new StdErrErrorHandler());
        }
        this(loggerSettings, errorHandler);
    }

    @NotNull
    protected LoggerSettings getSettings() {
        return this.settings;
    }

    @NotNull
    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @NotNull
    protected CopyOnWriteArrayList<String> getRecordsQueue() {
        return this.recordsQueue;
    }

    @NotNull
    protected RestHighLevelClient getRestClient() {
        return this.restClient;
    }

    @NotNull
    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    @NotNull
    protected AtomicBoolean getHandleRecords() {
        return this.handleRecords;
    }

    @NotNull
    protected AtomicBoolean isClosed() {
        return this.isClosed;
    }

    @NotNull
    protected DateTimeFormatter getTimestampFormatter() {
        return this.timestampFormatter;
    }

    @NotNull
    protected Thread getWorkerThread() {
        return this.workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData() {
        while (this.getHandleRecords().get()) {
            CopyOnWriteArrayList<String> copyOnWriteArrayList = this.getRecordsQueue();
            boolean bl = false;
            if (!copyOnWriteArrayList.isEmpty()) {
                copyOnWriteArrayList = this.getRecordsQueue();
                bl = false;
                boolean bl2 = false;
                synchronized (copyOnWriteArrayList) {
                    boolean bl3 = false;
                    this.sendNextBatch();
                    Unit unit = Unit.INSTANCE;
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.getSettings().getSendLogRecordsPeriodMillis());
            }
            catch (Exception exception) {}
        }
        this.getErrorHandler().logInfo("sendData() thread has stopped");
    }

    protected void sendNextBatch() {
        try {
            List<String> recordsToSend = this.calculateRecordsToSend();
            try {
                BulkResponse response = this.sendRecords(recordsToSend);
                if (response.hasFailures()) {
                    this.getErrorHandler().logError("Could not send log records to Elasticsearch: " + response.status() + ' ' + response.buildFailureMessage());
                    this.reAddFailedItemsToQueue(response, recordsToSend);
                }
            }
            catch (Exception e) {
                this.getErrorHandler().logError("Could not send batch with " + recordsToSend.size() + " items to Elasticsearch", e);
                this.reAddSentItemsToQueue(recordsToSend);
            }
        }
        catch (Exception e) {
            this.getErrorHandler().logError("Could not calculate next batch to send to Elasticsearch", e);
        }
    }

    @NotNull
    protected BulkResponse sendRecords(@NotNull List<String> recordsToSend) {
        Intrinsics.checkNotNullParameter(recordsToSend, (String)"recordsToSend");
        BulkRequest bulkRequest = this.createBulkRequest(recordsToSend);
        BulkResponse bulkResponse = this.getRestClient().bulk(bulkRequest, RequestOptions.DEFAULT);
        Intrinsics.checkNotNullExpressionValue((Object)bulkResponse, (String)"restClient.bulk(bulkRequest, RequestOptions.DEFAULT)");
        return bulkResponse;
    }

    @NotNull
    protected BulkRequest createBulkRequest(@NotNull List<String> recordsToSend) {
        Intrinsics.checkNotNullParameter(recordsToSend, (String)"recordsToSend");
        BulkRequest bulkRequest = new BulkRequest(this.getSettings().getIndexName());
        Iterable $this$forEach$iv = recordsToSend;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String recordJson = (String)element$iv;
            boolean bl = false;
            IndexRequest request = new IndexRequest(this.getSettings().getIndexName());
            request.source(recordJson, XContentType.JSON);
            bulkRequest.add(request);
        }
        return bulkRequest;
    }

    @NotNull
    protected List<String> calculateRecordsToSend() {
        int size = this.getRecordsQueue().size();
        if (size <= this.getSettings().getMaxLogRecordsPerBatch()) {
            ArrayList recordsToSend = new ArrayList(this.getRecordsQueue());
            this.getRecordsQueue().clear();
            return recordsToSend;
        }
        int fromIndex = size - this.getSettings().getMaxLogRecordsPerBatch();
        ArrayList recordsToSend = new ArrayList(this.getRecordsQueue().subList(fromIndex, size));
        while (this.getRecordsQueue().size() > fromIndex) {
            this.getRecordsQueue().remove(fromIndex);
        }
        return recordsToSend;
    }

    /*
     * WARNING - void declaration
     */
    protected void reAddFailedItemsToQueue(@NotNull BulkResponse response, @NotNull List<String> sentRecords) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(sentRecords, (String)"sentRecords");
        BulkItemResponse[] bulkItemResponseArray = response.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)bulkItemResponseArray, (String)"response.items");
        Object[] $this$forEachIndexed$iv = bulkItemResponseArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n = index$iv++;
            BulkItemResponse bulkItemResponse = (BulkItemResponse)item$iv;
            int index = n;
            boolean bl = false;
            if (!item.isFailed()) continue;
            String failedRecord = sentRecords.get(index);
            this.getRecordsQueue().add(this.getRecordsQueue().size(), failedRecord);
        }
    }

    protected void reAddSentItemsToQueue(@NotNull List<String> sentRecords) {
        Intrinsics.checkNotNullParameter(sentRecords, (String)"sentRecords");
        this.getRecordsQueue().addAll(this.getRecordsQueue().size(), (Collection<String>)sentRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        try {
            String recordJson = this.createEsRecordJson(record);
            if (this.isClosed().get()) {
                this.sendRecords(CollectionsKt.listOf((Object)recordJson));
                return;
            }
            CopyOnWriteArrayList<String> copyOnWriteArrayList = this.getRecordsQueue();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (copyOnWriteArrayList) {
                boolean bl3 = false;
                this.getRecordsQueue().add(recordJson);
                while (this.getRecordsQueue().size() > this.getSettings().getMaxBufferedLogRecords()) {
                    CollectionsKt.removeLast((List)this.getRecordsQueue());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            this.getErrorHandler().logError("Could not queue record " + record + " to send to Elasticsearch", e);
        }
    }

    @Override
    public void close() {
        try {
            this.isClosed().set(true);
            this.getHandleRecords().set(false);
            ArrayList records = new ArrayList(this.getRecordsQueue());
            this.getRecordsQueue().clear();
            this.sendRecords(records);
            this.getWorkerThread().join(100L);
        }
        catch (Exception e) {
            this.getErrorHandler().logError("Could not stop ElasticsearchLogWriter");
        }
    }

    @NotNull
    protected String createEsRecordJson(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Map<String, Object> esRecord = this.mapToEsRecord(record);
        String string = this.getMapper().writeValueAsString(esRecord);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsString(esRecord)");
        return string;
    }

    @NotNull
    protected Map<String, Object> mapToEsRecord(@NotNull LogRecord record) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        boolean bl2 = false;
        Map esRecord = new LinkedHashMap();
        String message = null;
        message = record.getMessage();
        Object object2 = record.getException();
        if (object2 != null) {
            object = object2;
            boolean bl3 = false;
            bl = false;
            Map<String, String> exception = object;
            boolean bl4 = false;
            message = message + ": " + ((Throwable)((Object)exception)).getMessage();
        }
        object2 = esRecord;
        object = this.getSettings().getMessageFieldName();
        String string = message;
        bl = false;
        object2.put(object, string);
        object2 = esRecord;
        object = this.getSettings().getTimestampFieldName();
        string = this.formatTimestamp(record.getTimestamp());
        bl = false;
        object2.put(object, string);
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeLogLevel(), this.getSettings().getLogLevelFieldName(), record.getLevel());
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeLogger(), this.getSettings().getLoggerFieldName(), record.getLogger());
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeLoggerName(), this.getSettings().getLoggerNameFieldName(), (Function0<? extends Object>)((Function0)new Function0<Object>(this, record){
            final /* synthetic */ ElasticsearchLogWriter this$0;
            final /* synthetic */ LogRecord $record;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return ElasticsearchLogWriter.access$extractLoggerName(this.this$0, this.$record);
            }
        }));
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeThreadName(), this.getSettings().getThreadNameFieldName(), record.getThreadName());
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeHostName(), this.getSettings().getHostNameFieldName(), record.getHost());
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeStacktrace() && record.getException() != null, this.getSettings().getStacktraceFieldName(), (Function0<? extends Object>)((Function0)new Function0<Object>(this, record){
            final /* synthetic */ ElasticsearchLogWriter this$0;
            final /* synthetic */ LogRecord $record;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return this.this$0.extractStacktrace(this.$record);
            }
        }));
        if (this.getSettings().getIncludeMdc() && record.getMdc() != null && (object2 = record.getMdc()) != null) {
            object = object2;
            boolean bl5 = false;
            bl = false;
            Map<String, String> mdc = object;
            boolean bl6 = false;
            String prefix = this.determinePrefix(this.getSettings().getMdcKeysPrefix());
            Object object3 = mdc;
            boolean bl7 = false;
            Iterator<Map.Entry<String, String>> iterator = object3.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object4 = object3 = iterator.next();
                boolean bl8 = false;
                String key = (String)object4.getKey();
                Object object5 = object3;
                boolean bl9 = false;
                String value = (String)object5.getValue();
                esRecord.put(Intrinsics.stringPlus((String)prefix, (Object)key), value);
            }
        }
        object2 = record.getMarker();
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeMarker() && record.getMarker() != null, this.getSettings().getMarkerFieldName(), object2 == null ? "" : object2);
        object2 = record.getNdc();
        this.conditionallyAdd((Map<String, Object>)esRecord, this.getSettings().getIncludeNdc() && record.getNdc() != null, this.getSettings().getNdcFieldName(), object2 == null ? "" : object2);
        if (this.getSettings().getIncludeKubernetesInfo() && (object2 = record.getKubernetesInfo()) != null) {
            object = object2;
            boolean bl10 = false;
            bl = false;
            Object kubernetesInfo = object;
            boolean bl11 = false;
            this.addKubernetesInfoToEsRecord(esRecord, (KubernetesInfo)kubernetesInfo);
        }
        return esRecord;
    }

    private final void addKubernetesInfoToEsRecord(Map<String, Object> esRecord, KubernetesInfo info) {
        String prefix = this.determinePrefix(this.getSettings().getKubernetesFieldsPrefix());
        esRecord.put(Intrinsics.stringPlus((String)prefix, (Object)"namespace"), info.getNamespace());
        esRecord.put(Intrinsics.stringPlus((String)prefix, (Object)"podName"), info.getPodName());
        esRecord.put(Intrinsics.stringPlus((String)prefix, (Object)"podIp"), info.getPodIp());
        esRecord.put(Intrinsics.stringPlus((String)prefix, (Object)"startTime"), info.getStartTime());
        this.addIfNotNull(esRecord, prefix, "podUid", info.getPodUid());
        esRecord.put(Intrinsics.stringPlus((String)prefix, (Object)"restartCount"), info.getRestartCount());
        this.addIfNotNull(esRecord, prefix, "containerName", info.getContainerName());
        this.addIfNotNull(esRecord, prefix, "containerId", info.getContainerId());
        this.addIfNotNull(esRecord, prefix, "imageName", info.getImageName());
        this.addIfNotNull(esRecord, prefix, "imageId", info.getImageId());
        this.addIfNotNull(esRecord, prefix, "nodeIp", info.getNodeIp());
        this.addIfNotNull(esRecord, prefix, "node", info.getNodeName());
        this.addIfNotNull(esRecord, prefix, "clusterName", info.getClusterName());
        if (this.getSettings().getIncludeKubernetesLabels()) {
            String labelsPrefix = Intrinsics.stringPlus((String)prefix, (Object)this.determinePrefix(this.getSettings().getKubernetesLabelsPrefix()));
            info.getLabels().forEach((arg_0, arg_1) -> ElasticsearchLogWriter.addKubernetesInfoToEsRecord$lambda-7(esRecord, labelsPrefix, this, arg_0, arg_1));
        }
        if (this.getSettings().getIncludeKubernetesAnnotations()) {
            String annotationsPrefix = Intrinsics.stringPlus((String)prefix, (Object)this.determinePrefix(this.getSettings().getKubernetesAnnotationsPrefix()));
            info.getAnnotations().forEach((arg_0, arg_1) -> ElasticsearchLogWriter.addKubernetesInfoToEsRecord$lambda-8(esRecord, annotationsPrefix, this, arg_0, arg_1));
        }
    }

    private final String determinePrefix(String prefix) {
        CharSequence charSequence = prefix;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : Intrinsics.stringPlus((String)prefix, (Object)".");
    }

    @NotNull
    protected String convertToEsFieldName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.replace$default((String)name, (String)".", (String)"_", (boolean)false, (int)4, null);
    }

    protected void addIfNotNull(@NotNull Map<String, Object> record, @NotNull String fieldNamePrefix, @NotNull String fieldName, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldNamePrefix, (String)"fieldNamePrefix");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Object object = value;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Map<String, Object> map = record;
            String string = Intrinsics.stringPlus((String)fieldNamePrefix, (Object)fieldName);
            boolean bl4 = false;
            map.put(string, value);
        }
    }

    protected void conditionallyAdd(@NotNull Map<String, Object> record, boolean include, @NotNull String fieldName, @NotNull Function0<? extends Object> valueSupplier) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(valueSupplier, (String)"valueSupplier");
        if (include) {
            this.conditionallyAdd(record, include, fieldName, valueSupplier.invoke());
        }
    }

    protected void conditionallyAdd(@NotNull Map<String, Object> record, boolean include, @NotNull String fieldName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (include) {
            Map<String, Object> map = record;
            boolean bl = false;
            map.put(fieldName, value);
        }
    }

    @NotNull
    protected String formatTimestamp(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        String string = timestamp.atOffset(ZoneOffset.UTC).format(this.getTimestampFormatter());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"timestamp.atOffset(ZoneOffset.UTC).format(timestampFormatter)");
        return string;
    }

    @NotNull
    protected String extractStacktrace(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        StringWriter writer = new StringWriter();
        Object object = record.getException();
        if (object != null) {
            ((Throwable)object).printStackTrace(new PrintWriter(writer));
        }
        object = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"writer.toString()");
        return object;
    }

    private final String extractLoggerName(LogRecord record) {
        String loggerName = record.getLogger();
        int indexOfDot = StringsKt.lastIndexOf$default((CharSequence)loggerName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (indexOfDot >= 0) {
            String string = loggerName;
            int n = indexOfDot + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            loggerName = string3;
        }
        return loggerName;
    }

    @JvmOverloads
    public ElasticsearchLogWriter(@NotNull LoggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(settings, null, 2, null);
    }

    private static final void addKubernetesInfoToEsRecord$lambda-7(Map $esRecord, String $labelsPrefix, ElasticsearchLogWriter this$0, String name, String value) {
        Intrinsics.checkNotNullParameter((Object)$esRecord, (String)"$esRecord");
        Intrinsics.checkNotNullParameter((Object)$labelsPrefix, (String)"$labelsPrefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $esRecord.put(Intrinsics.stringPlus((String)$labelsPrefix, (Object)this$0.convertToEsFieldName(name)), value);
    }

    private static final void addKubernetesInfoToEsRecord$lambda-8(Map $esRecord, String $annotationsPrefix, ElasticsearchLogWriter this$0, String name, String value) {
        Intrinsics.checkNotNullParameter((Object)$esRecord, (String)"$esRecord");
        Intrinsics.checkNotNullParameter((Object)$annotationsPrefix, (String)"$annotationsPrefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $esRecord.put(Intrinsics.stringPlus((String)$annotationsPrefix, (Object)this$0.convertToEsFieldName(name)), value);
    }

    public static final /* synthetic */ String access$extractLoggerName(ElasticsearchLogWriter $this, LogRecord record) {
        return $this.extractLoggerName(record);
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy-MM-dd'T'HH:mm:ss.SSSZ\")");
        MillisTimestampFormatter = dateTimeFormatter;
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ\")");
        MicrosTimestampFormatter = dateTimeFormatter;
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZ");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZ\")");
        NanosTimestampFormatter = dateTimeFormatter;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/codinux/log/elasticsearch/ElasticsearchLogWriter$Companion;", "", "()V", "MicrosTimestampFormatter", "Ljava/time/format/DateTimeFormatter;", "getMicrosTimestampFormatter", "()Ljava/time/format/DateTimeFormatter;", "MillisTimestampFormatter", "getMillisTimestampFormatter", "NanosTimestampFormatter", "getNanosTimestampFormatter", "ElasticsearchLoggerBase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getMillisTimestampFormatter() {
            return MillisTimestampFormatter;
        }

        @NotNull
        public final DateTimeFormatter getMicrosTimestampFormatter() {
            return MicrosTimestampFormatter;
        }

        @NotNull
        public final DateTimeFormatter getNanosTimestampFormatter() {
            return NanosTimestampFormatter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampResolution.values().length];
            nArray[TimestampResolution.Milliseconds.ordinal()] = 1;
            nArray[TimestampResolution.Microseconds.ordinal()] = 2;
            nArray[TimestampResolution.Nanoseconds.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

