/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.elasticsearch;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.elasticsearch.ElasticsearchLogWriter;
import net.codinux.log.elasticsearch.LogRecord;
import net.codinux.log.elasticsearch.LogWriter;
import net.codinux.log.elasticsearch.LoggerSettings;
import net.codinux.log.elasticsearch.errorhandler.ErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.OnlyOnceErrorHandler;
import net.codinux.log.elasticsearch.errorhandler.StdErrErrorHandler;
import net.codinux.log.elasticsearch.kubernetes.KubernetesInfo;
import net.codinux.log.elasticsearch.kubernetes.KubernetesInfoRetriever;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001bH\u0014J\b\u0010&\u001a\u00020\u001fH\u0014J\u001a\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0014J\b\u0010,\u001a\u00020\u001fH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lnet/codinux/log/elasticsearch/ElasticsearchLogHandler;", "", "settings", "Lnet/codinux/log/elasticsearch/LoggerSettings;", "errorHandler", "Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "(Lnet/codinux/log/elasticsearch/LoggerSettings;Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;)V", "getErrorHandler", "()Lnet/codinux/log/elasticsearch/errorhandler/ErrorHandler;", "handleLogs", "", "getHandleLogs", "()Z", "setHandleLogs", "(Z)V", "kubernetesInfo", "Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfo;", "getKubernetesInfo", "()Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfo;", "setKubernetesInfo", "(Lnet/codinux/log/elasticsearch/kubernetes/KubernetesInfo;)V", "logWriter", "Lnet/codinux/log/elasticsearch/LogWriter;", "getLogWriter", "()Lnet/codinux/log/elasticsearch/LogWriter;", "unhandledLogs", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lnet/codinux/log/elasticsearch/LogRecord;", "getUnhandledLogs", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "close", "", "createLogWriter", "Lnet/codinux/log/elasticsearch/ElasticsearchLogWriter;", "flush", "handle", "record", "handleRecord", "retrieveKubernetesInfo", "showError", "message", "", "e", "", "startLogRecordProcessing", "ElasticsearchLoggerBase"})
public class ElasticsearchLogHandler {
    @NotNull
    private final ErrorHandler errorHandler;
    @NotNull
    private final LogWriter logWriter;
    @Nullable
    private KubernetesInfo kubernetesInfo;
    @NotNull
    private final CopyOnWriteArrayList<LogRecord> unhandledLogs;
    private boolean handleLogs;

    @JvmOverloads
    public ElasticsearchLogHandler(@NotNull LoggerSettings settings, @NotNull ErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        this.errorHandler = errorHandler;
        this.logWriter = this.createLogWriter(settings);
        this.unhandledLogs = new CopyOnWriteArrayList();
        if (settings.getIncludeKubernetesInfo()) {
            this.retrieveKubernetesInfo();
        } else {
            this.setHandleLogs(true);
        }
    }

    public /* synthetic */ ElasticsearchLogHandler(LoggerSettings loggerSettings, ErrorHandler errorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorHandler = new OnlyOnceErrorHandler(new StdErrErrorHandler());
        }
        this(loggerSettings, errorHandler);
    }

    @NotNull
    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @NotNull
    protected LogWriter getLogWriter() {
        return this.logWriter;
    }

    @Nullable
    protected KubernetesInfo getKubernetesInfo() {
        return this.kubernetesInfo;
    }

    protected void setKubernetesInfo(@Nullable KubernetesInfo kubernetesInfo) {
        this.kubernetesInfo = kubernetesInfo;
    }

    @NotNull
    protected CopyOnWriteArrayList<LogRecord> getUnhandledLogs() {
        return this.unhandledLogs;
    }

    protected boolean getHandleLogs() {
        return this.handleLogs;
    }

    protected void setHandleLogs(boolean bl) {
        this.handleLogs = bl;
    }

    @NotNull
    protected ElasticsearchLogWriter createLogWriter(@NotNull LoggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ElasticsearchLogWriter(settings, this.getErrorHandler());
    }

    protected void retrieveKubernetesInfo() {
        new KubernetesInfoRetriever().retrieveKubernetesInfoAsync((Function1<? super KubernetesInfo, Unit>)((Function1)new Function1<KubernetesInfo, Unit>(this){
            final /* synthetic */ ElasticsearchLogHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable KubernetesInfo it) {
                this.this$0.setKubernetesInfo(it);
                this.this$0.startLogRecordProcessing();
            }
        }));
    }

    protected void startLogRecordProcessing() {
        this.setHandleLogs(true);
        Iterable $this$forEach$iv = this.getUnhandledLogs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogRecord it = (LogRecord)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.handleRecord(it);
        }
        this.getUnhandledLogs().clear();
    }

    public void handle(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (record.getMdc() == null) {
            Map mdc = MDC.getCopyOfContextMap();
            record.setMdc(mdc.isEmpty() ? null : mdc);
        }
        if (this.getHandleLogs()) {
            this.handleRecord(record);
        } else {
            this.getUnhandledLogs().add(record);
        }
    }

    protected void handleRecord(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        try {
            record.setKubernetesInfo(this.getKubernetesInfo());
            this.getLogWriter().writeRecord(record);
        }
        catch (Exception e) {
            this.showError(Intrinsics.stringPlus((String)"Could not process log record ", (Object)record), e);
        }
    }

    public void flush() {
    }

    public void close() {
        try {
            this.getLogWriter().close();
        }
        catch (Exception e) {
            this.showError(Intrinsics.stringPlus((String)"Could not stop Log Writer ", (Object)this.getLogWriter()), e);
        }
        this.getErrorHandler().logInfo(Intrinsics.stringPlus((String)"Closed ", (Object)this.getClass().getSimpleName()));
    }

    protected void showError(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getErrorHandler().logError(message, e);
    }

    @JvmOverloads
    public ElasticsearchLogHandler(@NotNull LoggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(settings, null, 2, null);
    }
}

