/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.i18n.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.codinux.i18n.LanguageTag;
import net.codinux.i18n.StringExtensionsKt;
import net.codinux.i18n.unit.UnitDisplayFormatNames;
import net.codinux.i18n.unit.UnitDisplayName;
import net.codinux.i18n.unit.UnitDisplayNameKey;
import net.codinux.i18n.unit.UnitDisplayNames;
import net.codinux.i18n.unit.UnitDisplayNamesResolver;
import net.codinux.i18n.unit.UnitFormatStyle;
import net.codinux.i18n.unit.UnitPrefix;
import net.codinux.log.Logger;
import net.codinux.log.LoggerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\"\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J*\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J6\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J&\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00192\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lnet/codinux/i18n/unit/UnitFormatter;", "", "resolver", "Lnet/codinux/i18n/unit/UnitDisplayNamesResolver;", "(Lnet/codinux/i18n/unit/UnitDisplayNamesResolver;)V", "log", "Lnet/codinux/log/Logger;", "getLog", "()Lnet/codinux/log/Logger;", "log$delegate", "Lnet/codinux/log/LoggerDelegate;", "getResolver", "()Lnet/codinux/i18n/unit/UnitDisplayNamesResolver;", "cleanAndGetUnitDisplayName", "", "unit", "style", "Lnet/codinux/i18n/unit/UnitFormatStyle;", "language", "Lnet/codinux/i18n/LanguageTag;", "extractPrefixes", "Lkotlin/Pair;", "", "Lnet/codinux/i18n/unit/UnitPrefix;", "findKey", "Lnet/codinux/i18n/unit/UnitDisplayNameKey;", "formatPart", "formatPerUnit", "numerator", "denominator", "formatPrefixes", "unitDisplayName", "prefixes", "getStyleDisplayNames", "Lnet/codinux/i18n/unit/UnitDisplayFormatNames;", "getUnitDisplayName", "k-i18n"})
@SourceDebugExtension(value={"SMAP\nUnitFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitFormatter.kt\nnet/codinux/i18n/unit/UnitFormatter\n+ 2 LoggerDelegate.kt\nnet/codinux/log/LoggerDelegateKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n9#2:182\n1549#3:183\n1620#3,3:184\n1726#3,3:187\n2661#3,7:190\n1855#3,2:197\n288#3,2:199\n1855#3,2:201\n*S KotlinDebug\n*F\n+ 1 UnitFormatter.kt\nnet/codinux/i18n/unit/UnitFormatter\n*L\n11#1:182\n74#1:183\n74#1:184,3\n75#1:187,3\n82#1:190,7\n96#1:197,2\n117#1:199,2\n139#1:201,2\n*E\n"})
public class UnitFormatter {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final UnitDisplayNamesResolver resolver;
    @NotNull
    private final LoggerDelegate log$delegate;

    public UnitFormatter(@NotNull UnitDisplayNamesResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.resolver = resolver;
        boolean $i$f$logger = false;
        this.log$delegate = new LoggerDelegate();
    }

    public /* synthetic */ UnitFormatter(UnitDisplayNamesResolver unitDisplayNamesResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            unitDisplayNamesResolver = new UnitDisplayNamesResolver();
        }
        this(unitDisplayNamesResolver);
    }

    @NotNull
    protected UnitDisplayNamesResolver getResolver() {
        return this.resolver;
    }

    private final Logger getLog() {
        return this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public String getUnitDisplayName(@NotNull UnitDisplayNameKey unit, @NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        UnitDisplayName unitDisplayName = this.getStyleDisplayNames(style, language2).getUnits().get(unit);
        return unitDisplayName != null ? unitDisplayName.getDisplayName() : null;
    }

    public static /* synthetic */ String getUnitDisplayName$default(UnitFormatter unitFormatter, UnitDisplayNameKey unitDisplayNameKey, UnitFormatStyle unitFormatStyle, LanguageTag languageTag, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnitDisplayName");
        }
        if ((n & 2) != 0) {
            unitFormatStyle = UnitFormatStyle.Long;
        }
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return unitFormatter.getUnitDisplayName(unitDisplayNameKey, unitFormatStyle, languageTag);
    }

    @Nullable
    public String getUnitDisplayName(@NotNull String unit, @NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        String unitDisplayName;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        String normalized = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)unit, (String)"metre", (String)"meter", (boolean)false, (int)4, null), (String)"litre", (String)"liter", (boolean)false, (int)4, null), (String)"deca", (String)"deka", (boolean)false, (int)4, null);
        UnitDisplayNameKey unitKey = this.findKey(normalized);
        if (unitKey != null && (unitDisplayName = this.getUnitDisplayName(unitKey, style, language2)) != null) {
            return unitDisplayName;
        }
        String[] stringArray = new String[]{" per "};
        List perParts = StringsKt.split$default((CharSequence)normalized, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (perParts.size() == 1) {
            return this.formatPart((String)CollectionsKt.first((List)perParts), style, language2);
        }
        if (perParts.size() == 2) {
            return this.formatPerUnit((String)CollectionsKt.first((List)perParts), (String)perParts.get(1), style, language2);
        }
        return null;
    }

    public static /* synthetic */ String getUnitDisplayName$default(UnitFormatter unitFormatter, String string, UnitFormatStyle unitFormatStyle, LanguageTag languageTag, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnitDisplayName");
        }
        if ((n & 2) != 0) {
            unitFormatStyle = UnitFormatStyle.Long;
        }
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return unitFormatter.getUnitDisplayName(string, unitFormatStyle, languageTag);
    }

    @Nullable
    public String cleanAndGetUnitDisplayName(@NotNull String unit, @NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        String cleaned = unit;
        Pair pair = TuplesKt.to((Object)StringExtensionsKt.indexOfOrNull$default((CharSequence)cleaned, '(', 0, false, 6, null), (Object)StringExtensionsKt.indexOfOrNull$default((CharSequence)cleaned, ')', 0, false, 6, null));
        Integer startIndex = (Integer)pair.component1();
        Integer endIndex = (Integer)pair.component2();
        if (startIndex != null && endIndex != null && startIndex < endIndex) {
            int n = startIndex;
            String string = cleaned.substring(n, endIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            cleaned = StringsKt.replace$default((String)cleaned, (String)string, (String)"", (boolean)false, (int)4, null);
        }
        Pair pair2 = TuplesKt.to((Object)StringExtensionsKt.indexOfOrNull$default((CharSequence)cleaned, '[', 0, false, 6, null), (Object)StringExtensionsKt.indexOfOrNull$default((CharSequence)cleaned, ']', 0, false, 6, null));
        Integer squareBracketStartIndex = (Integer)pair2.component1();
        Integer squareBracketEndIndex = (Integer)pair2.component2();
        if (squareBracketStartIndex != null && squareBracketEndIndex != null && squareBracketStartIndex < squareBracketEndIndex) {
            int n = squareBracketStartIndex;
            String string = cleaned.substring(n, squareBracketEndIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            cleaned = StringsKt.replace$default((String)cleaned, (String)string, (String)"", (boolean)false, (int)4, null);
        }
        return this.getUnitDisplayName(((Object)StringsKt.trim((CharSequence)cleaned)).toString(), style, language2);
    }

    public static /* synthetic */ String cleanAndGetUnitDisplayName$default(UnitFormatter unitFormatter, String string, UnitFormatStyle unitFormatStyle, LanguageTag languageTag, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: cleanAndGetUnitDisplayName");
        }
        if ((n & 2) != 0) {
            unitFormatStyle = UnitFormatStyle.Long;
        }
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return unitFormatter.cleanAndGetUnitDisplayName(string, unitFormatStyle, languageTag);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String formatPart(@NotNull String unit, @NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        String unitDisplayName;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Pair<String, List<UnitPrefix>> pair = this.extractPrefixes(unit);
        String remainingString = (String)pair.component1();
        List prefixes = (List)pair.component2();
        UnitDisplayNameKey unitKey = this.findKey(remainingString);
        if (unitKey != null && (unitDisplayName = this.getUnitDisplayName(unitKey, style, language2)) != null) {
            return this.formatPrefixes(unit, unitDisplayName, prefixes, style, language2);
        }
        char[] cArray = new char[]{' '};
        List parts = StringsKt.split$default((CharSequence)unit, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() > 1) {
            boolean bl;
            List partsFormatted;
            block12: {
                Iterator $this$mapTo$iv$iv;
                Iterable $this$map$iv = parts;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator.next();
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.formatPart((String)it, style, language2));
                }
                partsFormatted = (List)destination$iv$iv;
                Iterable $this$all$iv = partsFormatted;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (it != null) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                String string;
                String timesPattern;
                String string2 = timesPattern = style == UnitFormatStyle.Long ? null : this.getStyleDisplayNames(style, language2).getTimesPattern();
                if (timesPattern == null) {
                    string = CollectionsKt.joinToString$default((Iterable)partsFormatted, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                } else {
                    Iterable $this$reduce$iv = partsFormatted;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void part;
                        String bl3 = (String)iterator$iv.next();
                        String acc = (String)accumulator$iv;
                        boolean bl4 = false;
                        String string3 = acc;
                        if (string3 == null) {
                            string3 = "";
                        }
                        String string4 = StringsKt.replace$default((String)timesPattern, (String)"{0}", (String)string3, (boolean)false, (int)4, null);
                        void v5 = part;
                        Intrinsics.checkNotNull((Object)v5);
                        accumulator$iv = StringsKt.replace$default((String)string4, (String)"{1}", (String)v5, (boolean)false, (int)4, null);
                    }
                    string = (String)accumulator$iv;
                }
                return string;
            }
        }
        return null;
    }

    @NotNull
    protected String formatPrefixes(@NotNull String unit, @NotNull String unitDisplayName, @NotNull List<? extends UnitPrefix> prefixes, @NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)unitDisplayName, (String)"unitDisplayName");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        String formatted = null;
        formatted = unitDisplayName;
        if (!((Collection)prefixes).isEmpty()) {
            UnitDisplayFormatNames displayNames = this.getStyleDisplayNames(style, language2);
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)prefixes);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String displayName;
                UnitPrefix prefix = (UnitPrefix)element$iv;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[prefix.ordinal()]) {
                    case 1: {
                        String string = displayNames.getSquarePattern();
                        break;
                    }
                    case 2: {
                        String string = displayNames.getCubicPattern();
                        break;
                    }
                    default: {
                        String string = displayName = displayNames.getPrefixPatterns().get(prefix);
                    }
                }
                if (displayName != null) {
                    formatted = StringsKt.replace$default((String)displayName, (String)"{0}", (String)formatted, (boolean)false, (int)4, null);
                    continue;
                }
                Logger.DefaultImpls.debug$default((Logger)this.getLog(), null, (Function0)((Function0)new Function0<String>(prefix, language2, unit){
                    final /* synthetic */ UnitPrefix $prefix;
                    final /* synthetic */ LanguageTag $language;
                    final /* synthetic */ String $unit;
                    {
                        this.$prefix = $prefix;
                        this.$language = $language;
                        this.$unit = $unit;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Could not format prefix " + this.$prefix + " for locale " + this.$language + " in unit string '" + this.$unit + "'";
                    }
                }), (int)1, null);
            }
        }
        return formatted;
    }

    @Nullable
    protected UnitDisplayNameKey findKey(@NotNull String unit) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            String string = unit.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String unitKeyFormat = StringsKt.replace$default((String)string, (char)' ', (char)'-', (boolean)false, (int)4, null);
            Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UnitDisplayNameKey key = (UnitDisplayNameKey)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)key.getKey(), (Object)unitKeyFormat) || StringsKt.equals((String)unit, (String)key.getEnglishName(), (boolean)true))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    protected Pair<String, List<UnitPrefix>> extractPrefixes(@NotNull String unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        String remainingString = null;
        remainingString = unit;
        List prefixes = new ArrayList();
        if (StringsKt.contains$default((CharSequence)remainingString, (CharSequence)"squared", (boolean)false, (int)2, null)) {
            remainingString = StringsKt.replace$default((String)remainingString, (String)"squared", (String)"", (boolean)false, (int)4, null);
            prefixes.add(UnitPrefix.Square);
        }
        if (StringsKt.contains$default((CharSequence)remainingString, (CharSequence)"square ", (boolean)false, (int)2, null)) {
            remainingString = StringsKt.replace$default((String)remainingString, (String)"square ", (String)"", (boolean)false, (int)4, null);
            prefixes.add(UnitPrefix.Square);
        }
        if (StringsKt.contains$default((CharSequence)remainingString, (CharSequence)"cubic ", (boolean)false, (int)2, null)) {
            remainingString = StringsKt.replace$default((String)remainingString, (String)"cubic ", (String)"", (boolean)false, (int)4, null);
            prefixes.add(UnitPrefix.Cubic);
        }
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$1;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnitPrefix unitPrefix = (UnitPrefix)element$iv;
            boolean bl = false;
            String prefixName = unitPrefix.getEnglishName();
            if (!StringsKt.contains$default((CharSequence)remainingString, (CharSequence)prefixName, (boolean)false, (int)2, null)) continue;
            remainingString = StringsKt.replace$default((String)remainingString, (String)prefixName, (String)"", (boolean)false, (int)4, null);
            prefixes.add(unitPrefix);
        }
        return new Pair((Object)((Object)StringsKt.trim((CharSequence)remainingString)).toString(), (Object)prefixes);
    }

    @Nullable
    protected String formatPerUnit(@NotNull String numerator, @NotNull String denominator, @NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        String numeratorFormatted = this.formatPart(numerator, style, language2);
        if (numeratorFormatted != null) {
            Pair<String, List<UnitPrefix>> pair = this.extractPrefixes(denominator);
            String remainingString = (String)pair.component1();
            List prefixes = (List)pair.component2();
            UnitDisplayNameKey unitKey = this.findKey(remainingString);
            if (unitKey != null) {
                String perUnitPattern;
                UnitDisplayName unitDisplayName = this.getStyleDisplayNames(style, language2).getUnits().get(unitKey);
                String string = perUnitPattern = unitDisplayName != null ? unitDisplayName.getPerUnitPattern() : null;
                if (perUnitPattern != null) {
                    String denominatorFormatted = this.formatPrefixes(denominator, perUnitPattern, prefixes, style, language2);
                    return StringsKt.replace$default((String)denominatorFormatted, (String)"{0}", (String)numeratorFormatted, (boolean)false, (int)4, null);
                }
            } else {
                Logger.DefaultImpls.debug$default((Logger)this.getLog(), null, (Function0)((Function0)new Function0<String>(remainingString, denominator){
                    final /* synthetic */ String $remainingString;
                    final /* synthetic */ String $denominator;
                    {
                        this.$remainingString = $remainingString;
                        this.$denominator = $denominator;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Could not find UnitKey for '" + this.$remainingString + "' of denominator '" + this.$denominator + "'";
                    }
                }), (int)1, null);
            }
        }
        return null;
    }

    @NotNull
    protected UnitDisplayFormatNames getStyleDisplayNames(@NotNull UnitFormatStyle style, @NotNull LanguageTag language2) {
        UnitDisplayFormatNames unitDisplayFormatNames;
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        UnitDisplayNames displayNames = this.getResolver().getDisplayNamesForLocale(language2);
        switch (WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
            case 1: {
                unitDisplayFormatNames = displayNames.getLong();
                break;
            }
            case 2: {
                unitDisplayFormatNames = displayNames.getShort();
                break;
            }
            case 3: {
                unitDisplayFormatNames = displayNames.getNarrow();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return unitDisplayFormatNames;
    }

    public UnitFormatter() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UnitFormatter.class, "log", "getLog()Lnet/codinux/log/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<UnitDisplayNameKey> entries$0;
        public static final /* synthetic */ EnumEntries<UnitPrefix> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])UnitDisplayNameKey.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])UnitPrefix.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnitPrefix.values().length];
            try {
                nArray[UnitPrefix.Square.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnitPrefix.Cubic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UnitFormatStyle.values().length];
            try {
                nArray[UnitFormatStyle.Long.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnitFormatStyle.Short.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnitFormatStyle.Narrow.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

