/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.i18n.formatter;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.codinux.i18n.Currency;
import net.codinux.i18n.LanguageTag;
import net.codinux.i18n.StringExtensionsKt;
import net.codinux.i18n.formatter.AvailableNumberFormats;
import net.codinux.i18n.formatter.CurrencyFormat;
import net.codinux.i18n.formatter.DecimalFormat;
import net.codinux.i18n.formatter.NumberFormat;
import net.codinux.i18n.formatter.NumberFormatPattern;
import net.codinux.i18n.formatter.NumberFormatter;
import net.codinux.i18n.formatter.Symbols;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0010\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0016JC\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0014J0\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001a\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0019H\u0016J\u001a\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001f\u0010$\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0002\u0010%J'\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0002\u0010'\u00a8\u0006("}, d2={"Lnet/codinux/i18n/formatter/NumberFormatter;", "", "()V", "format", "", "number", "", "formatPattern", "symbols", "Lnet/codinux/i18n/formatter/Symbols;", "countFractionalDigits", "", "isCurrency", "", "multiplyNumberWith", "format$k_i18n", "(Ljava/lang/Number;Ljava/lang/String;Lnet/codinux/i18n/formatter/Symbols;Ljava/lang/Integer;ZLjava/lang/Integer;)Ljava/lang/String;", "formatCurrency", "currency", "Lnet/codinux/i18n/Currency;", "locale", "Lnet/codinux/i18n/LanguageTag;", "(Ljava/lang/Number;Lnet/codinux/i18n/Currency;Lnet/codinux/i18n/LanguageTag;Ljava/lang/Integer;)Ljava/lang/String;", "Lnet/codinux/i18n/formatter/CurrencyFormat;", "(Ljava/lang/Number;Lnet/codinux/i18n/Currency;Lnet/codinux/i18n/formatter/CurrencyFormat;Lnet/codinux/i18n/formatter/Symbols;Lnet/codinux/i18n/LanguageTag;Ljava/lang/Integer;)Ljava/lang/String;", "Lnet/codinux/i18n/formatter/NumberFormat;", "(Ljava/lang/Number;Lnet/codinux/i18n/Currency;Lnet/codinux/i18n/formatter/NumberFormat;Lnet/codinux/i18n/LanguageTag;Ljava/lang/Integer;)Ljava/lang/String;", "formatFractionPart", "numberAsString", "pattern", "Lnet/codinux/i18n/formatter/NumberFormatPattern;", "formatIntegerPart", "formatNumber", "Lnet/codinux/i18n/formatter/DecimalFormat;", "formatPercent", "getNumberFormat", "parsePattern", "(Ljava/lang/String;Ljava/lang/Integer;)Lnet/codinux/i18n/formatter/NumberFormatPattern;", "roundAndConvertToString", "(Ljava/lang/Number;Lnet/codinux/i18n/formatter/NumberFormatPattern;Ljava/lang/Integer;)Ljava/lang/String;", "k-i18n"})
@SourceDebugExtension(value={"SMAP\nNumberFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormatter.kt\nnet/codinux/i18n/formatter/NumberFormatter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,250:1\n1766#2,2:251\n1099#2,3:253\n1099#2,3:256\n1099#2,3:259\n1099#2,3:262\n*S KotlinDebug\n*F\n+ 1 NumberFormatter.kt\nnet/codinux/i18n/formatter/NumberFormatter\n*L\n142#1:251,2\n211#1:253,3\n218#1:256,3\n219#1:259,3\n228#1:262,3\n*E\n"})
public class NumberFormatter {
    @NotNull
    public String formatNumber(@NotNull Number number, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.formatNumber(number, this.getNumberFormat(locale));
    }

    public static /* synthetic */ String formatNumber$default(NumberFormatter numberFormatter, Number number, LanguageTag languageTag, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatNumber");
        }
        if ((n & 2) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return numberFormatter.formatNumber(number, languageTag);
    }

    @NotNull
    public String formatNumber(@NotNull Number number, @NotNull NumberFormat format) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Object v = format.getDecimalFormats().get(format.getDefaultNumberingSystem());
        Intrinsics.checkNotNull(v);
        DecimalFormat decimalFormat = (DecimalFormat)v;
        Object v2 = format.getSymbols().get(format.getDefaultNumberingSystem());
        Intrinsics.checkNotNull(v2);
        return this.formatNumber(number, decimalFormat, (Symbols)v2);
    }

    @NotNull
    public String formatNumber(@NotNull Number number, @NotNull DecimalFormat format, @NotNull Symbols symbols) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        return NumberFormatter.format$k_i18n$default(this, number, format.getStandard(), symbols, null, false, null, 56, null);
    }

    @NotNull
    public String formatPercent(@NotNull Number number, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.formatPercent(number, this.getNumberFormat(locale));
    }

    public static /* synthetic */ String formatPercent$default(NumberFormatter numberFormatter, Number number, LanguageTag languageTag, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatPercent");
        }
        if ((n & 2) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return numberFormatter.formatPercent(number, languageTag);
    }

    @NotNull
    public String formatPercent(@NotNull Number number, @NotNull NumberFormat format) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Object v = format.getPercentFormats().get(format.getDefaultNumberingSystem());
        Intrinsics.checkNotNull(v);
        DecimalFormat decimalFormat = (DecimalFormat)v;
        Object v2 = format.getSymbols().get(format.getDefaultNumberingSystem());
        Intrinsics.checkNotNull(v2);
        return this.formatPercent(number, decimalFormat, (Symbols)v2);
    }

    @NotNull
    public String formatPercent(@NotNull Number number, @NotNull DecimalFormat format, @NotNull Symbols symbols) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        return NumberFormatter.format$k_i18n$default(this, number, format.getStandard(), symbols, null, false, 100, 24, null);
    }

    @NotNull
    public String formatCurrency(@NotNull Number number, @NotNull Currency currency, @NotNull LanguageTag locale, @Nullable Integer countFractionalDigits) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.formatCurrency(number, currency, this.getNumberFormat(locale), locale, countFractionalDigits);
    }

    public static /* synthetic */ String formatCurrency$default(NumberFormatter numberFormatter, Number number, Currency currency, LanguageTag languageTag, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatCurrency");
        }
        if ((n2 & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return numberFormatter.formatCurrency(number, currency, languageTag, n);
    }

    @NotNull
    public String formatCurrency(@NotNull Number number, @NotNull Currency currency, @NotNull NumberFormat format, @NotNull LanguageTag locale, @Nullable Integer countFractionalDigits) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Object v = format.getCurrencyFormats().get(format.getDefaultNumberingSystem());
        Intrinsics.checkNotNull(v);
        CurrencyFormat currencyFormat = (CurrencyFormat)v;
        Object v2 = format.getSymbols().get(format.getDefaultNumberingSystem());
        Intrinsics.checkNotNull(v2);
        return this.formatCurrency(number, currency, currencyFormat, (Symbols)v2, locale, countFractionalDigits);
    }

    public static /* synthetic */ String formatCurrency$default(NumberFormatter numberFormatter, Number number, Currency currency, NumberFormat numberFormat, LanguageTag languageTag, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatCurrency");
        }
        if ((n2 & 8) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return numberFormatter.formatCurrency(number, currency, numberFormat, languageTag, n);
    }

    @NotNull
    public String formatCurrency(@NotNull Number number, @NotNull Currency currency, @NotNull CurrencyFormat format, @NotNull Symbols symbols, @NotNull LanguageTag locale, @Nullable Integer countFractionalDigits) {
        String string;
        String formattedNumber;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string2 = format.getStandard();
        Integer n = countFractionalDigits;
        if (n == null) {
            n = currency.getDefaultFractionDigits();
        }
        if (StringsKt.contains$default((CharSequence)(formattedNumber = NumberFormatter.format$k_i18n$default(this, number, string2, symbols, n, true, null, 32, null)), (CharSequence)"\u00a4\u00a4\u00a4\u00a4\u00a4", (boolean)false, (int)2, null)) {
            String string3 = currency.getSymbolVariant();
            if (string3 == null && (string3 = currency.getSymbol()) == null) {
                string3 = currency.getAlpha3Code();
            }
            string = StringsKt.replace$default((String)formattedNumber, (String)"\u00a4\u00a4\u00a4\u00a4\u00a4", (String)string3, (boolean)false, (int)4, null);
        } else if (StringsKt.contains$default((CharSequence)formattedNumber, (CharSequence)"\u00a4\u00a4", (boolean)false, (int)2, null)) {
            string = StringsKt.replace$default((String)formattedNumber, (String)"\u00a4\u00a4", (String)currency.getAlpha3Code(), (boolean)false, (int)4, null);
        } else {
            String string4 = currency.getSymbol();
            if (string4 == null && (string4 = currency.getSymbolVariant()) == null) {
                string4 = currency.getAlpha3Code();
            }
            string = StringsKt.replace$default((String)StringsKt.replaceFirst$default((String)formattedNumber, (String)"\u00a4", (String)string4, (boolean)false, (int)4, null), (String)"\u00a4", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    public static /* synthetic */ String formatCurrency$default(NumberFormatter numberFormatter, Number number, Currency currency, CurrencyFormat currencyFormat, Symbols symbols, LanguageTag languageTag, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatCurrency");
        }
        if ((n2 & 0x10) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        return numberFormatter.formatCurrency(number, currency, currencyFormat, symbols, languageTag, n);
    }

    @NotNull
    public String format$k_i18n(@NotNull Number number, @NotNull String formatPattern, @NotNull Symbols symbols, @Nullable Integer countFractionalDigits, boolean isCurrency, @Nullable Integer multiplyNumberWith) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)formatPattern, (String)"formatPattern");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        if (number instanceof Double) {
            if (Double.isNaN(number.doubleValue())) {
                return symbols.getNan();
            }
            if (Double.isInfinite(number.doubleValue())) {
                if (number.doubleValue() > 0.0) {
                    return symbols.getInfinity();
                }
                return symbols.getMinusSign() + symbols.getInfinity();
            }
        } else if (number instanceof Float) {
            if (Float.isNaN(number.floatValue())) {
                return symbols.getNan();
            }
            if (Float.isInfinite(number.floatValue())) {
                if (number.floatValue() > 0.0f) {
                    return symbols.getInfinity();
                }
                return symbols.getMinusSign() + symbols.getInfinity();
            }
        }
        NumberFormatPattern pattern = this.parsePattern(formatPattern, countFractionalDigits);
        String numberAsString = this.roundAndConvertToString(number, pattern, multiplyNumberWith);
        String integerPart = this.formatIntegerPart(number, numberAsString, pattern, symbols, isCurrency);
        String fractionPart = this.formatFractionPart(numberAsString, pattern, symbols);
        if (StringsKt.isBlank((CharSequence)fractionPart)) {
            object = integerPart;
        } else {
            boolean bl;
            block14: {
                CharSequence $this$none$iv = fractionPart;
                boolean $i$f$none = false;
                for (int i = 0; i < $this$none$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$none$iv.charAt(i);
                    boolean bl2 = false;
                    if (!Character.isDigit(it)) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
            if (bl) {
                object = integerPart + fractionPart;
            } else {
                String decimalSeparator = isCurrency && symbols.getCurrencyDecimal() != null ? symbols.getCurrencyDecimal() : symbols.getDecimal();
                object = integerPart + decimalSeparator + fractionPart;
            }
        }
        return object;
    }

    public static /* synthetic */ String format$k_i18n$default(NumberFormatter numberFormatter, Number number, String string, Symbols symbols, Integer n, boolean bl, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: format");
        }
        if ((n3 & 8) != 0) {
            n = null;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        return numberFormatter.format$k_i18n(number, string, symbols, n, bl, n2);
    }

    @NotNull
    protected String formatIntegerPart(@NotNull Number number, @NotNull String numberAsString, @NotNull NumberFormatPattern pattern, @NotNull Symbols symbols, boolean isCurrency) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)numberAsString, (String)"numberAsString");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        Object integerPart = StringsKt.substringBefore$default((String)numberAsString, (char)'.', null, (int)2, null);
        if (pattern.getMinimumIntegerDigits() > 0) {
            integerPart = StringsKt.padStart((String)integerPart, (int)pattern.getMinimumIntegerDigits(), (char)'0');
        }
        if (pattern.getGroupSize() > 0) {
            String string;
            if (isCurrency && symbols.getCurrencyGroup() != null) {
                String string2 = symbols.getCurrencyGroup();
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
            } else {
                string = symbols.getGroup();
            }
            String groupSeparator = string;
            integerPart = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)StringsKt.chunked((CharSequence)((Object)StringsKt.reversed((CharSequence)((CharSequence)integerPart))).toString(), (int)pattern.getGroupSize())), (CharSequence)groupSeparator, null, null, (int)0, null, (Function1)formatIntegerPart.1.INSTANCE, (int)30, null);
        }
        if (number.longValue() < 0L) {
            integerPart = "-" + (String)integerPart;
        }
        return pattern.getStringBeforeIntegerPart() + (String)integerPart + pattern.getStringAfterIntegerPart();
    }

    @NotNull
    protected String formatFractionPart(@NotNull String numberAsString, @NotNull NumberFormatPattern pattern, @NotNull Symbols symbols) {
        Intrinsics.checkNotNullParameter((Object)numberAsString, (String)"numberAsString");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        String fractionPart = StringsKt.substringAfter((String)numberAsString, (char)'.', (String)"");
        if (pattern.getMinimumFractionDigits() > 0) {
            fractionPart = StringsKt.padEnd((String)fractionPart, (int)pattern.getMinimumFractionDigits(), (char)'0');
        }
        if (pattern.getMaximumFractionDigits() > 0 && fractionPart.length() > pattern.getMaximumFractionDigits()) {
            String string = fractionPart.substring(0, pattern.getMaximumFractionDigits());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fractionPart = string;
        }
        while (StringsKt.endsWith$default((CharSequence)fractionPart, (char)'0', (boolean)false, (int)2, null) && fractionPart.length() > pattern.getMinimumFractionDigits()) {
            Intrinsics.checkNotNullExpressionValue((Object)fractionPart.substring(0, fractionPart.length() - 1), (String)"substring(...)");
        }
        return pattern.getStringBeforeFractionPart() + fractionPart + pattern.getStringAfterFractionPart();
    }

    @NotNull
    protected String roundAndConvertToString(@NotNull Number number, @NotNull NumberFormatPattern pattern, @Nullable Integer multiplyNumberWith) {
        String string;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (number instanceof Float || number instanceof Double) {
            double factor = Math.pow(10.0, pattern.getMaximumFractionDigits());
            Integer n = multiplyNumberWith;
            double rounded = Math.rint(number.doubleValue() * (double)(n != null ? n : 1) * factor) / factor;
            string = String.valueOf(Math.abs(rounded));
        } else {
            Integer n = multiplyNumberWith;
            string = String.valueOf(Math.abs(number.longValue() * (long)(n != null ? n : 1)));
        }
        return string;
    }

    @NotNull
    protected NumberFormatPattern parsePattern(@NotNull String formatPattern, @Nullable Integer countFractionalDigits) {
        int n;
        String string;
        String string2;
        int n2;
        int element$iv;
        int n3;
        Intrinsics.checkNotNullParameter((Object)formatPattern, (String)"formatPattern");
        String patternIntegerPart = StringsKt.substringBefore$default((String)formatPattern, (char)'.', null, (int)2, null);
        CharSequence $this$count$iv = patternIntegerPart;
        boolean $i$f$count22 = false;
        int count$iv22 = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv2;
            char it = element$iv2 = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '0')) continue;
            ++count$iv22;
        }
        int minimumIntegerDigits = count$iv22;
        char[] $i$f$count22 = new char[]{'0', '#'};
        int integerNumbersStartIndex = StringsKt.indexOfAny$default((CharSequence)patternIntegerPart, (char[])$i$f$count22, (int)0, (boolean)false, (int)6, null);
        char[] count$iv22 = new char[]{'0', '#'};
        int integerNumberEndIndex = StringsKt.lastIndexOfAny$default((CharSequence)patternIntegerPart, (char[])count$iv22, (int)0, (boolean)false, (int)6, null);
        String string3 = patternIntegerPart.substring(0, integerNumbersStartIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String stringBeforeIntegerPart = string3;
        String string4 = patternIntegerPart.substring(integerNumberEndIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String stringAfterIntegerPart = string4;
        String patternFractionPart = StringsKt.substringAfter((String)formatPattern, (char)'.', (String)"");
        Integer n4 = countFractionalDigits;
        if (n4 != null) {
            n3 = n4;
        } else {
            CharSequence $this$count$iv2 = patternFractionPart;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv2.length(); ++i) {
                int it = element$iv = $this$count$iv2.charAt(i);
                boolean bl = false;
                if (!(it == 48)) continue;
                ++count$iv;
            }
            n3 = count$iv;
        }
        int minimumFractionDigits = n3;
        Integer n5 = countFractionalDigits;
        if (n5 != null) {
            n2 = n5;
        } else {
            CharSequence $this$count$iv3 = patternFractionPart;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (element$iv = 0; element$iv < $this$count$iv3.length(); ++element$iv) {
                char element$iv3;
                char it = element$iv3 = $this$count$iv3.charAt(element$iv);
                boolean bl = false;
                if (!(it == '0' || it == '#')) continue;
                ++count$iv;
            }
            n2 = count$iv;
        }
        int maximumFractionDigits = n2;
        char[] $i$f$count = new char[]{'0', '#'};
        int fractionNumbersStartIndex = StringsKt.indexOfAny$default((CharSequence)patternFractionPart, (char[])$i$f$count, (int)0, (boolean)false, (int)6, null);
        char[] count$iv = new char[]{'0', '#'};
        int fractionNumberEndIndex = StringsKt.lastIndexOfAny$default((CharSequence)patternFractionPart, (char[])count$iv, (int)0, (boolean)false, (int)6, null);
        if (fractionNumbersStartIndex == -1) {
            string2 = "";
        } else {
            String string5 = patternFractionPart.substring(0, fractionNumbersStartIndex);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        }
        String stringBeforeFractionPart = string2;
        if (fractionNumberEndIndex == -1) {
            string = "";
        } else {
            String string6 = patternFractionPart.substring(fractionNumberEndIndex + 1);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        }
        String stringAfterFractionPart = string;
        Integer indexOfGroupingSeparator = StringExtensionsKt.lastIndexOfOrNull$default((CharSequence)patternIntegerPart, ',', 0, false, 6, null);
        if (indexOfGroupingSeparator != null) {
            CharSequence $this$count$iv4 = StringsKt.drop((String)patternIntegerPart, (int)indexOfGroupingSeparator);
            boolean $i$f$count3 = false;
            int count$iv3 = 0;
            for (int i = 0; i < $this$count$iv4.length(); ++i) {
                char element$iv4;
                char it = element$iv4 = $this$count$iv4.charAt(i);
                boolean bl = false;
                if (!(it == '0' || it == '#')) continue;
                ++count$iv3;
            }
            n = count$iv3;
        } else {
            n = 0;
        }
        int groupSize = n;
        return new NumberFormatPattern(formatPattern, minimumIntegerDigits, minimumFractionDigits, maximumFractionDigits, groupSize, stringBeforeIntegerPart, stringAfterIntegerPart, stringBeforeFractionPart, stringAfterFractionPart);
    }

    @NotNull
    protected NumberFormat getNumberFormat(@NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        NumberFormat numberFormat = AvailableNumberFormats.INSTANCE.getNumberFormat(locale.getTag());
        if (numberFormat != null) {
            return numberFormat;
        }
        LanguageTag languageTag = locale.getParent();
        if (languageTag != null) {
            LanguageTag parent2 = languageTag;
            boolean bl = false;
            return this.getNumberFormat(parent2);
        }
        throw new IllegalArgumentException("Number format not found for locale '" + locale + "' or its parents. Are you sure this locale exists?");
    }
}

