/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.i18n.datetime;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.codinux.i18n.LanguageTag;
import net.codinux.i18n.datetime.DateFieldWidth;
import net.codinux.i18n.datetime.DateOrTimeFormats;
import net.codinux.i18n.datetime.DateTimeDisplayNames;
import net.codinux.i18n.datetime.DateTimeDisplayNamesResolver;
import net.codinux.i18n.datetime.DateTimeFormat;
import net.codinux.i18n.datetime.DateTimeFormatPattern;
import net.codinux.i18n.datetime.DayDisplayNames;
import net.codinux.i18n.datetime.DayOfWeek;
import net.codinux.i18n.datetime.DayPeriodDisplayNames;
import net.codinux.i18n.datetime.DisplayNameSet;
import net.codinux.i18n.datetime.FormatStyle;
import net.codinux.i18n.datetime.HourStyle;
import net.codinux.i18n.datetime.LocalDate;
import net.codinux.i18n.datetime.LocalTime;
import net.codinux.i18n.datetime.LocalizedDateTimeFormats;
import net.codinux.i18n.datetime.LocalizedDateTimeFormatsResolver;
import net.codinux.i18n.datetime.Month;
import net.codinux.i18n.datetime.MonthDisplayNames;
import net.codinux.i18n.datetime.MonthStyle;
import net.codinux.i18n.datetime.QuarterDisplayNames;
import net.codinux.i18n.datetime.WeekDayStyle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00162\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00172\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u00162\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00172\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0018\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/codinux/i18n/datetime/DateTimeFormatter;", "", "formatsResolver", "Lnet/codinux/i18n/datetime/LocalizedDateTimeFormatsResolver;", "displayNamesResolver", "Lnet/codinux/i18n/datetime/DateTimeDisplayNamesResolver;", "(Lnet/codinux/i18n/datetime/LocalizedDateTimeFormatsResolver;Lnet/codinux/i18n/datetime/DateTimeDisplayNamesResolver;)V", "format", "", "day", "Lnet/codinux/i18n/datetime/DayOfWeek;", "style", "Lnet/codinux/i18n/datetime/WeekDayStyle;", "locale", "Lnet/codinux/i18n/LanguageTag;", "month", "Lnet/codinux/i18n/datetime/Month;", "Lnet/codinux/i18n/datetime/DateFieldWidth;", "formatDate", "date", "Lnet/codinux/i18n/datetime/LocalDate;", "formatPattern", "Lnet/codinux/i18n/datetime/DateTimeFormat;", "Lnet/codinux/i18n/datetime/FormatStyle;", "formatTime", "time", "Lnet/codinux/i18n/datetime/LocalTime;", "getDayNames", "Lnet/codinux/i18n/datetime/DisplayNameSet;", "Lnet/codinux/i18n/datetime/DayDisplayNames;", "getDayPeriodNames", "Lnet/codinux/i18n/datetime/DayPeriodDisplayNames;", "getDisplayNames", "Lnet/codinux/i18n/datetime/DateTimeDisplayNames;", "getMonthNames", "Lnet/codinux/i18n/datetime/MonthDisplayNames;", "getQuarterNames", "Lnet/codinux/i18n/datetime/QuarterDisplayNames;", "parsePattern", "Lnet/codinux/i18n/datetime/DateTimeFormatPattern;", "selectFormat", "formats", "Lnet/codinux/i18n/datetime/DateOrTimeFormats;", "k-i18n"})
@SourceDebugExtension(value={"SMAP\nDateTimeFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeFormatter.kt\nnet/codinux/i18n/datetime/DateTimeFormatter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1099#2,3:308\n1099#2,3:312\n1099#2,3:315\n1099#2,3:318\n1099#2,3:321\n1099#2,3:324\n1099#2,3:327\n1099#2,3:330\n1099#2,3:333\n1099#2,3:336\n1099#2,3:339\n1099#2,3:342\n1099#2,3:345\n1#3:311\n*S KotlinDebug\n*F\n+ 1 DateTimeFormatter.kt\nnet/codinux/i18n/datetime/DateTimeFormatter\n*L\n222#1:308,3\n227#1:312,3\n238#1:315,3\n248#1:318,3\n252#1:321,3\n253#1:324,3\n267#1:327,3\n268#1:330,3\n269#1:333,3\n270#1:336,3\n279#1:339,3\n282#1:342,3\n285#1:345,3\n*E\n"})
public final class DateTimeFormatter {
    @NotNull
    private final LocalizedDateTimeFormatsResolver formatsResolver;
    @NotNull
    private final DateTimeDisplayNamesResolver displayNamesResolver;

    public DateTimeFormatter(@NotNull LocalizedDateTimeFormatsResolver formatsResolver, @NotNull DateTimeDisplayNamesResolver displayNamesResolver) {
        Intrinsics.checkNotNullParameter((Object)formatsResolver, (String)"formatsResolver");
        Intrinsics.checkNotNullParameter((Object)displayNamesResolver, (String)"displayNamesResolver");
        this.formatsResolver = formatsResolver;
        this.displayNamesResolver = displayNamesResolver;
    }

    public /* synthetic */ DateTimeFormatter(LocalizedDateTimeFormatsResolver localizedDateTimeFormatsResolver, DateTimeDisplayNamesResolver dateTimeDisplayNamesResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            localizedDateTimeFormatsResolver = new LocalizedDateTimeFormatsResolver();
        }
        if ((n & 2) != 0) {
            dateTimeDisplayNamesResolver = new DateTimeDisplayNamesResolver();
        }
        this(localizedDateTimeFormatsResolver, dateTimeDisplayNamesResolver);
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate date, @NotNull FormatStyle style, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        LocalizedDateTimeFormats formats = this.formatsResolver.getDateTimeFormatsForLocale(locale);
        return this.formatDate(date, this.selectFormat(formats.getDateFormats(), style), locale);
    }

    public static /* synthetic */ String formatDate$default(DateTimeFormatter dateTimeFormatter, LocalDate localDate, FormatStyle formatStyle, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.formatDate(localDate, formatStyle, languageTag);
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate date, @NotNull DateTimeFormat format, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.formatDate(date, format.getDateFormat(), locale);
    }

    public static /* synthetic */ String formatDate$default(DateTimeFormatter dateTimeFormatter, LocalDate localDate, DateTimeFormat dateTimeFormat, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.formatDate(localDate, dateTimeFormat, languageTag);
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate date, @NotNull String formatPattern, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)formatPattern, (String)"formatPattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateTimeFormatPattern pattern = this.parsePattern(formatPattern);
        String formatted = pattern.getPattern();
        if (pattern.getYearMinLength() != null) {
            String year = StringsKt.padStart((String)String.valueOf(date.getYear()), (int)pattern.getYearMinLength(), (char)'0');
            if (pattern.getYearMaxLength() != null) {
                String string = year.substring(year.length() - pattern.getYearMaxLength());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                year = string;
            }
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)"y", (int)pattern.getYearMinLength()), (String)year, (boolean)false, (int)4, null);
        }
        if (pattern.getMonthStyle() != null) {
            String string;
            MonthStyle monthStyle = pattern.getMonthStyle();
            switch (monthStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[monthStyle.ordinal()]) {
                case 1: {
                    string = String.valueOf(date.getMonth());
                    break;
                }
                case 2: {
                    string = StringsKt.padStart((String)String.valueOf(date.getMonth()), (int)2, (char)'0');
                    break;
                }
                case 3: {
                    string = this.getMonthNames(locale).getAbbreviated().getMonth(date);
                    break;
                }
                case 4: {
                    string = this.getMonthNames(locale).getWide().getMonth(date);
                    break;
                }
                case 5: {
                    string = this.getMonthNames(locale).getNarrow().getMonth(date);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String month = string;
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)"M", (int)pattern.getMonthFormatFieldsLength()), (String)month, (boolean)false, (int)4, null);
        }
        if (pattern.getDayMinLength() != null) {
            String day = StringsKt.padStart((String)String.valueOf(date.getDayOfMonth()), (int)pattern.getDayMinLength(), (char)'0');
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)"d", (int)pattern.getDayMinLength()), (String)day, (boolean)false, (int)4, null);
        }
        return formatted;
    }

    public static /* synthetic */ String formatDate$default(DateTimeFormatter dateTimeFormatter, LocalDate localDate, String string, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.formatDate(localDate, string, languageTag);
    }

    @NotNull
    public final String formatTime(@NotNull LocalTime time, @NotNull FormatStyle style, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        LocalizedDateTimeFormats formats = this.formatsResolver.getDateTimeFormatsForLocale(locale);
        return this.formatTime(time, this.selectFormat(formats.getTimeFormats(), style), locale);
    }

    public static /* synthetic */ String formatTime$default(DateTimeFormatter dateTimeFormatter, LocalTime localTime, FormatStyle formatStyle, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.formatTime(localTime, formatStyle, languageTag);
    }

    @NotNull
    public final String formatTime(@NotNull LocalTime time, @NotNull DateTimeFormat format, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.formatTime(time, format.getDateFormat(), locale);
    }

    public static /* synthetic */ String formatTime$default(DateTimeFormatter dateTimeFormatter, LocalTime localTime, DateTimeFormat dateTimeFormat, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.formatTime(localTime, dateTimeFormat, languageTag);
    }

    @NotNull
    public final String formatTime(@NotNull LocalTime time, @NotNull String formatPattern, @NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)formatPattern, (String)"formatPattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateTimeFormatPattern pattern = this.parsePattern(formatPattern);
        String formatted = pattern.getPattern();
        if (pattern.getHourStyle() != null) {
            Pair pair;
            HourStyle hourStyle = pattern.getHourStyle();
            switch (hourStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$1[hourStyle.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    pair = TuplesKt.to((Object)String.valueOf(time.getHour() == 0 || time.getHour() == 12 ? 12 : time.getHour() % 12), (Object)"h");
                    break;
                }
                case 4: {
                    pair = TuplesKt.to((Object)String.valueOf(time.getHour()), (Object)"H");
                    break;
                }
                case 5: {
                    pair = TuplesKt.to((Object)String.valueOf(time.getHour() % 12), (Object)"K");
                    break;
                }
                case 6: {
                    pair = TuplesKt.to((Object)String.valueOf(time.getHour() == 0 ? 24 : time.getHour()), (Object)"k");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            String hour = (String)pair2.component1();
            String hourPattern = (String)pair2.component2();
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)hourPattern, (int)pattern.getHourMinLength()), (String)StringsKt.padStart((String)hour, (int)pattern.getHourMinLength(), (char)'0'), (boolean)false, (int)4, null);
        }
        if (pattern.getMinuteMinLength() != null) {
            String minute = StringsKt.padStart((String)String.valueOf(time.getMinute()), (int)pattern.getMinuteMinLength(), (char)'0');
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)"m", (int)pattern.getMinuteMinLength()), (String)minute, (boolean)false, (int)4, null);
        }
        if (pattern.getSecondMinLength() != null) {
            String second = StringsKt.padStart((String)String.valueOf(time.getSecond()), (int)pattern.getSecondMinLength(), (char)'0');
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)"s", (int)pattern.getSecondMinLength()), (String)second, (boolean)false, (int)4, null);
        }
        if (pattern.getFractionalSecondLength() != null) {
            String string = StringsKt.padStart((String)String.valueOf(time.getNanosecondOfSecond()), (int)pattern.getFractionalSecondLength(), (char)'0').substring(0, pattern.getFractionalSecondLength());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String fractionalSecond = string;
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)"S", (int)pattern.getFractionalSecondLength()), (String)fractionalSecond, (boolean)false, (int)4, null);
        }
        if (pattern.getDayPeriodStyle() != null) {
            String string;
            DateFieldWidth dateFieldWidth = pattern.getDayPeriodStyle();
            switch (dateFieldWidth == null ? -1 : WhenMappings.$EnumSwitchMapping$2[dateFieldWidth.ordinal()]) {
                case 1: {
                    string = this.getDayPeriodNames(locale).getAbbreviated().getDayPeriod(time, pattern.getAlsoFormatNoonAndMidnight());
                    break;
                }
                case 2: {
                    string = this.getDayPeriodNames(locale).getWide().getDayPeriod(time, pattern.getAlsoFormatNoonAndMidnight());
                    break;
                }
                case 3: {
                    string = this.getDayPeriodNames(locale).getNarrow().getDayPeriod(time, pattern.getAlsoFormatNoonAndMidnight());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String dayPeriod = string;
            formatted = StringsKt.replace$default((String)formatted, (String)StringsKt.repeat((CharSequence)(pattern.getAlsoFormatNoonAndMidnight() ? "b" : "a"), (int)pattern.getDayPeriodFormatFieldsLength()), (String)dayPeriod, (boolean)false, (int)4, null);
        }
        return formatted;
    }

    public static /* synthetic */ String formatTime$default(DateTimeFormatter dateTimeFormatter, LocalTime localTime, String string, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.formatTime(localTime, string, languageTag);
    }

    @NotNull
    public final String format(@NotNull Month month, @NotNull DateFieldWidth style, @NotNull LanguageTag locale) {
        MonthDisplayNames monthDisplayNames;
        Intrinsics.checkNotNullParameter((Object)((Object)month), (String)"month");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DisplayNameSet<MonthDisplayNames> displayNameSet = this.getMonthNames(locale);
        switch (WhenMappings.$EnumSwitchMapping$2[style.ordinal()]) {
            case 2: {
                monthDisplayNames = displayNameSet.getWide();
                break;
            }
            case 1: {
                monthDisplayNames = displayNameSet.getAbbreviated();
                break;
            }
            case 3: {
                monthDisplayNames = displayNameSet.getNarrow();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MonthDisplayNames displayNames = monthDisplayNames;
        return displayNames.getMonth(month);
    }

    public static /* synthetic */ String format$default(DateTimeFormatter dateTimeFormatter, Month month, DateFieldWidth dateFieldWidth, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.format(month, dateFieldWidth, languageTag);
    }

    @NotNull
    public final String format(@NotNull DayOfWeek day, @NotNull WeekDayStyle style, @NotNull LanguageTag locale) {
        DayDisplayNames dayDisplayNames;
        Intrinsics.checkNotNullParameter((Object)((Object)day), (String)"day");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DisplayNameSet<DayDisplayNames> displayNamesSet = this.getDayNames(locale);
        switch (WhenMappings.$EnumSwitchMapping$3[style.ordinal()]) {
            case 1: {
                dayDisplayNames = displayNamesSet.getWide();
                break;
            }
            case 2: {
                dayDisplayNames = displayNamesSet.getAbbreviated();
                break;
            }
            case 3: {
                dayDisplayNames = displayNamesSet.getNarrow();
                break;
            }
            case 4: {
                dayDisplayNames = displayNamesSet.getShort();
                if (dayDisplayNames != null) break;
                dayDisplayNames = displayNamesSet.getNarrow();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DayDisplayNames displayNames = dayDisplayNames;
        return displayNames.getDay(day);
    }

    public static /* synthetic */ String format$default(DateTimeFormatter dateTimeFormatter, DayOfWeek dayOfWeek, WeekDayStyle weekDayStyle, LanguageTag languageTag, int n, Object object) {
        if ((n & 4) != 0) {
            languageTag = LanguageTag.Companion.getCurrent();
        }
        return dateTimeFormatter.format(dayOfWeek, weekDayStyle, languageTag);
    }

    private final DisplayNameSet<MonthDisplayNames> getMonthNames(LanguageTag locale) {
        return this.getDisplayNames(locale).getMonths();
    }

    private final DisplayNameSet<DayDisplayNames> getDayNames(LanguageTag locale) {
        return this.getDisplayNames(locale).getDays();
    }

    private final DisplayNameSet<QuarterDisplayNames> getQuarterNames(LanguageTag locale) {
        return this.getDisplayNames(locale).getQuarters();
    }

    private final DisplayNameSet<DayPeriodDisplayNames> getDayPeriodNames(LanguageTag locale) {
        return this.getDisplayNames(locale).getDayPeriods();
    }

    private final DateTimeDisplayNames getDisplayNames(LanguageTag locale) {
        DateTimeDisplayNames displayNames = this.displayNamesResolver.getLocalizedFormatDisplayNames(locale);
        if (displayNames == null) {
            throw new IllegalArgumentException("Localized date time names not found for locale '" + locale + "' or its parents. Are you sure this locale exists?");
        }
        return displayNames;
    }

    private final DateTimeFormatPattern parsePattern(String formatPattern) {
        int it;
        int element$iv;
        int element$iv2;
        int element$iv3;
        DateFieldWidth dateFieldWidth;
        int it2;
        int n;
        int it3;
        int it4;
        WeekDayStyle weekDayStyle;
        int it5;
        MonthStyle monthStyle;
        int it6;
        int n2;
        CharSequence $this$count$iv = formatPattern;
        boolean $i$f$count22 = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv4;
            char it7 = element$iv4 = $this$count$iv.charAt(i);
            n2 = 0;
            if (!(it7 == 'y')) continue;
            ++count$iv;
        }
        int yearLength = count$iv;
        Integer $i$f$count22 = yearLength;
        int it8 = ((Number)$i$f$count22).intValue();
        boolean bl = false;
        Integer yearMinLength = !(it8 == 0) ? $i$f$count22 : null;
        Integer yearMaxLength = yearLength == 2 ? Integer.valueOf(2) : null;
        CharSequence $this$count$iv2 = formatPattern;
        boolean $i$f$count = false;
        int count$iv2 = 0;
        for (n2 = 0; n2 < $this$count$iv2.length(); ++n2) {
            int element$iv5;
            it6 = element$iv5 = $this$count$iv2.charAt(n2);
            boolean bl2 = false;
            if (!(it6 == 77)) continue;
            ++count$iv2;
        }
        int monthLength = count$iv2;
        switch (monthLength) {
            case 1: {
                monthStyle = MonthStyle.NumericMinDigits;
                break;
            }
            case 2: {
                monthStyle = MonthStyle.Numeric2Digits;
                break;
            }
            case 3: {
                monthStyle = MonthStyle.Abbreviated;
                break;
            }
            case 4: {
                monthStyle = MonthStyle.Wide;
                break;
            }
            case 5: {
                monthStyle = MonthStyle.Narrow;
                break;
            }
            default: {
                monthStyle = null;
            }
        }
        MonthStyle monthStyle2 = monthStyle;
        CharSequence $this$count$iv3 = formatPattern;
        boolean $i$f$count3 = false;
        int count$iv3 = 0;
        for (it6 = 0; it6 < $this$count$iv3.length(); ++it6) {
            int element$iv6;
            it5 = element$iv6 = $this$count$iv3.charAt(it6);
            boolean bl3 = false;
            if (!(it5 == 69)) continue;
            ++count$iv3;
        }
        int weekDayLength = count$iv3;
        switch (weekDayLength) {
            case 1: 
            case 2: 
            case 3: {
                weekDayStyle = WeekDayStyle.Abbreviated;
                break;
            }
            case 4: {
                weekDayStyle = WeekDayStyle.Wide;
                break;
            }
            case 5: {
                weekDayStyle = WeekDayStyle.Narrow;
                break;
            }
            case 6: {
                weekDayStyle = WeekDayStyle.Short;
                break;
            }
            default: {
                weekDayStyle = null;
            }
        }
        WeekDayStyle weekDayStyle2 = weekDayStyle;
        CharSequence $this$count$iv4 = formatPattern;
        boolean $i$f$count322 = false;
        int count$iv4 = 0;
        for (it5 = 0; it5 < $this$count$iv4.length(); ++it5) {
            int element$iv7;
            it4 = element$iv7 = $this$count$iv4.charAt(it5);
            boolean bl4 = false;
            if (!(it4 == 100)) continue;
            ++count$iv4;
        }
        int dayLength = count$iv4;
        Integer $i$f$count322 = dayLength;
        int it9 = ((Number)$i$f$count322).intValue();
        boolean bl5 = false;
        Integer dayMinLength = (1 <= it9 ? it9 < 3 : false) ? $i$f$count322 : null;
        CharSequence $this$count$iv5 = formatPattern;
        boolean $i$f$count4 = false;
        int count$iv222 = 0;
        for (it4 = 0; it4 < $this$count$iv5.length(); ++it4) {
            int element$iv8;
            it3 = element$iv8 = $this$count$iv5.charAt(it4);
            boolean bl6 = false;
            if (!(it3 == 98)) continue;
            ++count$iv222;
        }
        int dayPeriodNoonMidnightLength = count$iv222;
        Integer count$iv222 = dayPeriodNoonMidnightLength;
        it4 = ((Number)count$iv222).intValue();
        boolean bl7 = false;
        Integer n3 = !(it4 == 0) ? count$iv222 : null;
        if (n3 != null) {
            n = n3;
        } else {
            CharSequence $this$count$iv6 = formatPattern;
            boolean $i$f$count5 = false;
            int count$iv5 = 0;
            for (it3 = 0; it3 < $this$count$iv6.length(); ++it3) {
                int element$iv9;
                it2 = element$iv9 = $this$count$iv6.charAt(it3);
                boolean bl8 = false;
                if (!(it2 == 97)) continue;
                ++count$iv5;
            }
            n = count$iv5;
        }
        int dayPeriodLength = n;
        boolean alsoFormatNoonAndMidnight = dayPeriodNoonMidnightLength > 0;
        switch (dayPeriodLength) {
            case 1: 
            case 2: 
            case 3: {
                dateFieldWidth = DateFieldWidth.Abbreviated;
                break;
            }
            case 4: {
                dateFieldWidth = DateFieldWidth.Wide;
                break;
            }
            case 5: {
                dateFieldWidth = DateFieldWidth.Narrow;
                break;
            }
            default: {
                dateFieldWidth = null;
            }
        }
        DateFieldWidth dayPeriodStyle = dateFieldWidth;
        CharSequence $this$count$iv7 = formatPattern;
        boolean $i$f$count6 = false;
        int count$iv6 = 0;
        for (it2 = 0; it2 < $this$count$iv7.length(); ++it2) {
            int it10 = element$iv3 = $this$count$iv7.charAt(it2);
            boolean bl9 = false;
            if (!(it10 == 104)) continue;
            ++count$iv6;
        }
        int twelveHoursOneBasedLength = count$iv6;
        CharSequence $this$count$iv8 = formatPattern;
        boolean $i$f$count7 = false;
        int count$iv7 = 0;
        for (element$iv3 = 0; element$iv3 < $this$count$iv8.length(); ++element$iv3) {
            int it11 = element$iv2 = $this$count$iv8.charAt(element$iv3);
            boolean bl10 = false;
            if (!(it11 == 72)) continue;
            ++count$iv7;
        }
        int twentyFourHoursZeroBasedLength = count$iv7;
        CharSequence $this$count$iv9 = formatPattern;
        boolean $i$f$count8 = false;
        int count$iv8 = 0;
        for (element$iv2 = 0; element$iv2 < $this$count$iv9.length(); ++element$iv2) {
            int it12 = element$iv = $this$count$iv9.charAt(element$iv2);
            boolean bl11 = false;
            if (!(it12 == 75)) continue;
            ++count$iv8;
        }
        int twelveHoursZeroBasedLength = count$iv8;
        CharSequence $this$count$iv10 = formatPattern;
        boolean $i$f$count9 = false;
        int count$iv9 = 0;
        for (element$iv = 0; element$iv < $this$count$iv10.length(); ++element$iv) {
            char element$iv10;
            char it13 = element$iv10 = $this$count$iv10.charAt(element$iv);
            boolean bl12 = false;
            if (!(it13 == 'k')) continue;
            ++count$iv9;
        }
        int twentyFourHoursOneBasedLength = count$iv9;
        Pair pair = twelveHoursOneBasedLength != 0 ? TuplesKt.to((Object)((Object)HourStyle.TwelveHourStart1), (Object)twelveHoursOneBasedLength) : (twentyFourHoursZeroBasedLength != 0 ? TuplesKt.to((Object)((Object)HourStyle.TwentyFourHourStart0), (Object)twentyFourHoursZeroBasedLength) : (twelveHoursZeroBasedLength != 0 ? TuplesKt.to((Object)((Object)HourStyle.TwelveHourStart0), (Object)twelveHoursZeroBasedLength) : (twentyFourHoursOneBasedLength != 0 ? TuplesKt.to((Object)((Object)HourStyle.TwentyFourHourStart1), (Object)twentyFourHoursOneBasedLength) : TuplesKt.to(null, (Object)0))));
        HourStyle hourStyle = (HourStyle)((Object)pair.component1());
        int hourMinLength = ((Number)pair.component2()).intValue();
        CharSequence $this$count$iv11 = formatPattern;
        boolean $i$f$count422 = false;
        int count$iv10 = 0;
        for (int i = 0; i < $this$count$iv11.length(); ++i) {
            int element$iv11;
            it = element$iv11 = $this$count$iv11.charAt(i);
            boolean bl13 = false;
            if (!(it == 109)) continue;
            ++count$iv10;
        }
        int minuteLength = count$iv10;
        Integer $i$f$count422 = minuteLength;
        int it14 = ((Number)$i$f$count422).intValue();
        boolean bl14 = false;
        Integer minuteMinLength = (1 <= it14 ? it14 < 3 : false) ? $i$f$count422 : null;
        CharSequence $this$count$iv12 = formatPattern;
        boolean $i$f$count52 = false;
        int count$iv11 = 0;
        for (it = 0; it < $this$count$iv12.length(); ++it) {
            char element$iv12;
            char it15 = element$iv12 = $this$count$iv12.charAt(it);
            boolean bl15 = false;
            if (!(it15 == 's')) continue;
            ++count$iv11;
        }
        int secondLength = count$iv11;
        Integer $i$f$count52 = secondLength;
        int it16 = ((Number)$i$f$count52).intValue();
        boolean bl16 = false;
        Integer secondMinLength = (1 <= it16 ? it16 < 3 : false) ? $i$f$count52 : null;
        CharSequence $this$count$iv13 = formatPattern;
        boolean $i$f$count10 = false;
        int count$iv12 = 0;
        for (int i = 0; i < $this$count$iv13.length(); ++i) {
            char element$iv13;
            char it17 = element$iv13 = $this$count$iv13.charAt(i);
            boolean bl17 = false;
            if (!(it17 == 'S')) continue;
            ++count$iv12;
        }
        Integer n4 = count$iv12;
        it = ((Number)n4).intValue();
        boolean bl18 = false;
        Integer fractionalSecondLength = !(it == 0) ? n4 : null;
        return new DateTimeFormatPattern(formatPattern, yearMinLength, yearMaxLength, monthStyle2, monthLength, weekDayStyle2, weekDayLength, dayMinLength, dayPeriodStyle, dayPeriodLength, alsoFormatNoonAndMidnight, hourStyle, hourMinLength, minuteMinLength, secondMinLength, fractionalSecondLength);
    }

    private final String selectFormat(DateOrTimeFormats formats, FormatStyle style) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$4[style.ordinal()]) {
            case 1: {
                string = formats.getFull();
                break;
            }
            case 2: {
                string = formats.getLong();
                break;
            }
            case 3: {
                string = formats.getMedium();
                break;
            }
            case 4: {
                string = formats.getShort();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public DateTimeFormatter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[MonthStyle.values().length];
            try {
                nArray[MonthStyle.NumericMinDigits.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonthStyle.Numeric2Digits.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonthStyle.Abbreviated.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonthStyle.Wide.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonthStyle.Narrow.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HourStyle.values().length];
            try {
                nArray[HourStyle.TwelveHourStart1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HourStyle.TwelveHourStart1_NoonAndMidght.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HourStyle.TwelveHourStart1_FlexibleDayPeriods.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HourStyle.TwentyFourHourStart0.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HourStyle.TwelveHourStart0.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HourStyle.TwentyFourHourStart1.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[DateFieldWidth.values().length];
            try {
                nArray[DateFieldWidth.Abbreviated.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateFieldWidth.Wide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateFieldWidth.Narrow.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[WeekDayStyle.values().length];
            try {
                nArray[WeekDayStyle.Wide.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekDayStyle.Abbreviated.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekDayStyle.Narrow.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekDayStyle.Short.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[FormatStyle.values().length];
            try {
                nArray[FormatStyle.Full.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatStyle.Long.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatStyle.Medium.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatStyle.Short.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

